% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_lines.R
\name{write_lines}
\alias{write_file}
\alias{write_lines}
\title{Write lines/ a file}
\usage{
write_lines(x, path, na = "NA", append = FALSE)

write_file(x, path, append = FALSE)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{path}{Path to write to.}

\item{na}{String used for missing values. Defaults to NA. Missing values
will never be quoted; strings with the same value as \code{na} will
always be quoted.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if file does not exist a new
file is created.}
}
\value{
The input \code{x}, invisibly.
}
\description{
\code{write_lines} takes a character vector, appending a new line
after entry. \code{write_file} takes a single string, or a raw vector,
and writes it exactly as is.
}
\examples{
tmp <- tempfile()

write_lines(rownames(mtcars), tmp)
read_lines(tmp)
read_file(tmp) # note trailing \\n

write_lines(airquality$Ozone, tmp, na = "-1")
read_lines(tmp)
}

