% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_abs_sheets.R
\name{extract_abs_sheets}
\alias{extract_abs_sheets}
\title{Extract data sheets from an ABS timeseries workbook saved locally as an
.xls file.}
\usage{
extract_abs_sheets(
  filename,
  table_title = NULL,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir())
)
}
\arguments{
\item{filename}{Filename for an ABS time series spreadsheet (as string),
such as "6202002.xls".}

\item{table_title}{String giving the full title of the ABS table, such as
"Table 1. Employed persons, Australia"}

\item{path}{Local directory in which an ABS time series is stored. Default is
`Sys.getenv("R_READABS_PATH", unset = tempdir())`.}
}
\description{
Note that this function will not tidy the data for you.
Use `read_abs_local()`to import and tidy data from local ABS time series
spreadsheets or `read_abs()` to download, import and tidy ABS time series.
}
