% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackrock.R
\name{get_event}
\alias{get_event}
\title{Get event data packets from 'NEV'}
\usage{
get_event(x, event_type, ...)
}
\arguments{
\item{x}{path \code{prefix} (see \code{\link{import_nsp}}), or
\code{'nev/nsx'} object}

\item{event_type}{event type to load, common event types are
\describe{
\item{\code{'digital_inputs'}}{packet identifier 0}
\item{\code{'spike'}}{packet identifier 1 to 10000 as of version 3.0}
\item{\code{'recording'}}{packet identifier 65529 as of version 3.0, available after version 3.0}
\item{\code{'configuration'}}{packet identifier 65530 as of version 3.0, available after version 3.0}
\item{\code{'log'}}{packet identifier 65531 as of version 3.0, available after version 3.0}
\item{\code{'button_trigger'}}{packet identifier 65532 as of version 3.0, available after version 3.0}
\item{\code{'tracking'}}{packet identifier 65533 as of version 3.0, available after version 3.0}
\item{\code{'video_sync'}}{packet identifier 65534 as of version 3.0, available after version 3.0}
\item{\code{'comment'}}{packet identifier 65535 as of version 3.0, available after version 2.3}
}}

\item{...}{pass to other methods}
}
\value{
A data frame of corresponding event type, or \code{NULL} if event
is not found or invalid
}
\description{
Get event data packets from 'NEV'
}
