\name{dsDownload}
\alias{dsDownload}
\title{Run an external tool to download a data set.}
\description{
  The function allows to run an external download tool with arguments
  read from a file in a data folder.
}
\usage{
dsDownload(dsList, id, command, fileName)
}
\arguments{
  \item{dsList}{ Data frame as created by \code{prepareDSList()}.}
  \item{id}{ Name of the data set in \code{dsList$identification} or the index
    of the row in \code{dsList} corresponding to the data set.}
  \item{command}{ Character. A command line web downloding tool, for example
   \code{"wget"}.}
  \item{fileName}{ Character. A name of the file in the data directory,
   which contains the URL of the data on the web.}
}
\details{
	If no data set or more than one data set corresponding to \code{id} is found,
    a corresponding error message is printed.
}
\value{
  Function has no value. The protocol generated by the specified tool is printed.
}
\seealso{
\code{\link{readMLData}}.
}
\examples{
\dontrun{
  pathData <- getPath("exampleData")
  pathDescription <- getPath("exampleDescription")
  dsList <- prepareDSList(pathData, pathDescription)
  dat <- dsDownload(dsList, "glass", "wget", "links.txt")
}
}
\author{ Petr Savicky }
\keyword{ data }

