% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{cbind.genalex}
\alias{cbind.genalex}
\title{Combine loci from class \code{'genalex'} data sets}
\usage{
cbind.genalex(..., names = NULL, deparse.level = 1)
}
\arguments{
\item{names}{List of names: \code{title} for data set title,
\code{sample} for sample column header, and \code{pop} for population
column header.  If \code{names} or any of its fields are not provided,
the names of the first argument to \code{\dots} are used.}

\item{deparse.level}{Not used (yet)}

\item{\dots}{All arguments must be class \code{'genalex'} data sets.
If only one data set is supplied, it is returned unmodified.}
}
\value{
Annotated data frame of class \code{'genalex'}.  If \code{names}
or any of its fields are not provided, the names of the first argument
are used.  The \code{data.file.name} attribute is a character
representation of the call to \code{cbind}.
}
\description{
Combine loci from class \code{'genalex'} data sets into one larger class
\code{'genalex'} data set by adding loci.  Locus counts are adjusted
accordingly.  The data sets must have the same ploidy, sample names
and sample membership in populations.  The order of the samples may
differ, and the final data set will have the sample order of the first.
Locus names must be unique across all data sets; if any locus names are
duplicated, the genotypes are checked to assure they contain the exact
same data and if so, the duplicate locus columns are ignored.  Data set
title and sample and population column headers are taken from the first
data set unless supplied in the \code{names} argument.  As subsequent
data sets are added, they are compared against the aggregate data set
assembled thus far, so a data set might have duplicate columns versus
the aggregate that are not duplicates versus the first data set.  See
Details for how extra columns are handled.
}
\details{
Extra columns are taken from the first data set.  If the first data set
does not have extra columns but others do, extra columns are assembled
from data sets that have them.  Columns with the same name in extra
columns \emph{are dropped without checking contents}.  Columns with
different names are added with \code{\link{cbind}} to the right of the
existing set of extra columns.

Data sets must have the same number of rows, this is a necessary
consequence of containing the same samples.  Unlike the default
\code{cbind} method, values will not be recycled to create matching
row counts.
}
\note{
If one of the arguments is not of class \code{'genalex'}, then
this function will \emph{not} be called, instead \code{cbind.data.frame}
or perhaps another \code{cbind} method of base R will be called silently
and will return an object that is not of class \code{'genalex'}.  If
this occurs, none of the special processing for class \code{'genalex'}
objects will be applied and the result is probably not what you
intended.  If there is a chance you have mixed objects of different
classes while calling this function, assure that the return value is
class \code{'genalex'} by using \code{is.genalex}.

If you in fact want to add genotype data from a data frame or matrix
to an object of class \code{'genalex'}, then use \code{addLocus}.
}
\examples{
gt1 <- data.frame(a = 11:13, a.2 = 14:16, b = 101:103, b.2 = 104:106)
x1 <- genalex(1:3, "snurf", gt1)
gt2 <- data.frame(c = 21:23, c.2 = 24:26, d = 201:203, d.2 = 204:206)
x2 <- genalex(1:3, "snurf", gt2)
x <- cbind(x1, x2)
x
attributes(x)
}
\author{
Douglas G. Scofield
}
\seealso{
\code{\link{genalex}}, \code{\link{cbind}}, \code{\link{rbind.genalex}}
}

