% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_locate}
\alias{re2_locate}
\alias{re2_locate_all}
\title{Locate the start and end of pattern in a string}
\usage{
re2_locate(string, pattern)

re2_locate_all(string, pattern)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}
}
\value{
\code{re2_locate} returns an integer matrix, and
  \code{re2_locate_all} returns a list of integer matrices.
}
\description{
Vectorized over string and pattern. For matches of 0 length (ex.
  spatial patterns like "$") end will be one character greater than
  beginning.
}
\examples{
color <- c("yellowgreen", "steelblue", "goldenrod", "forestgreen")

re2_locate(color, "$")
re2_locate(color, "l")
re2_locate(color, "e")

# String length can be a multiple of pattern length
re2_locate(color, c("l(l|d)?", "st"))

# Locate all occurrences
re2_locate_all(color, "l")
re2_locate_all(color, "e")

# Locate all characters
re2_locate_all(color, ".")
}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax.
}
