% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locdir.R
\name{locdir}
\alias{locdir}
\title{local data directory}
\usage{
locdir(dir = getOption("rdwdlocdir"), file = NULL, quiet = rdwdquiet())
}
\arguments{
\item{dir}{Path to data directory.
If \code{dir} does not exist, \code{\link[=tempdir]{tempdir()}} is used instead
(with a warning, unless \code{quiet=TRUE}).
If \code{dir} is NULL, locdir tries "C:/DWDdata", then "~/DWDdata".\cr
\code{dir} can also be set with
\code{options(rdwdlocdir="YOUR/PATH")} thanks to the
DEFAULT: \link{getOption}\code{("rdwdlocdir")}}

\item{file}{Optional: path(s) at \code{dir}. DEFAULT: NULL}

\item{quiet}{Logical: suppress tempdir warning?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}
}
\value{
charstring (directory)
}
\description{
This can be used to set a directory for DWD data across projects,
thus avoiding multiple downloads of the same file.\cr
Set the default for all subsequent calls with \code{options(rdwdlocdir="YOUR/PATH")}.\cr
Currently, the \code{\link[=dataDWD]{dataDWD()}} \code{dir} defaults to a project specific folder at \link{getwd}.
In the future, this may change to \code{locdir()}.\cr
\code{locdir()} is used especially for the website, local tests and examples.
}
\examples{
locdir()
oldopt <- options(rdwdlocdir="~")
locdir()
stopifnot(locdir() == path.expand("~"))
options(oldopt) ; rm(oldopt)

}
\seealso{
\code{\link[=runLocalTests]{runLocalTests()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2019, Jun 2021
}
\keyword{file}
