% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExchangeRateService.R
\name{dfp_createExchangeRates}
\alias{dfp_createExchangeRates}
\title{ExchangeRateService}
\usage{
dfp_createExchangeRates(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createExchangeRatesResponse
}
\description{
Provides methods for adding, updating and retrieving ExchangeRate objects.
}
\details{
createExchangeRates

Creates new ExchangeRate objects. For each exchange rate, the following fields are required:
\itemize{
  \item{ExchangeRate currencyCode}
  \item{ExchangeRate exchangeRate when ExchangeRate refreshRate is ExchangeRateRefreshRate FIXED}
}
}
\examples{
\dontrun{
 res <- dfp_createExchangeRates(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ExchangeRateService#createExchangeRates}{Google Documentation for createExchangeRates}
}
