% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataAccs.R
\name{ddi_setAvail}
\alias{ddi_setAvail}
\alias{ddi_accsPlac}
\alias{ddi_avlStatus}
\alias{ddi_collSize}
\alias{ddi_complete}
\alias{ddi_fileQnty}
\alias{ddi_origArch}
\title{setAvail and its children}
\usage{
ddi_setAvail(...)

ddi_accsPlac(...)

ddi_avlStatus(...)

ddi_collSize(...)

ddi_complete(...)

ddi_fileQnty(...)

ddi_origArch(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Information on availability and storage of the data set collection. More
information on this element, especially the allowed attributes, can
be found in the references.
}
\details{
\emph{Parent node}

\code{setAvail} is contained in \code{dataAccs}.

\emph{setAvail specific child nodes}

\code{ddi_accsPlac()} is the location where the data collection is currently stored.
Use the URI attribute to provide a URN or URL for the storage site or the
actual address from which the data may be downloaded.

\code{ddi_avlStatus()} is the statement of collection availability. An archive may
need to indicate that a collection is unavailable because it is embargoed
for a period of time, because it has been superseded, because a new edition
is imminent, etc.

\code{ddi_collSize()} summarizes the number of physical files that exist in a
collection, recording the number of files that contain data and noting
whether the collection contains machine-readable documentation and/or other
supplementary files and information such as data dictionaries, data
definition statements, or data collection instruments.

\code{ddi_complete()} is the completeness of study stored. This item indicates the
relationship of the data collected to the amount of data coded and stored
in the data collection. Information as to why certain items of collected
information were not included in the data file stored by the archive should
be provided.

\code{ddi_fileQnty()} is the total number of physical files associated with a
collection.

\code{ddi_origArch()} is the archive from which the data collection was obtained;
the originating archive.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_notes]{ddi_notes()}}
}
}

\examples{
ddi_setAvail()

# Functions that need to be wrapped in ddi_setAvail()

ddi_accsPlac(URI = "https://dataverse.harvard.edu/",
             "Harvard Dataverse")

ddi_avlStatus("This collection is superseded by CENSUS OF POPULATION, 1880...")

ddi_collSize("1 data file + machine-readable documentation (PDF) + SAS data definition statements.")

ddi_complete("Because of embargo provisions, data values for some variables have been masked...")

ddi_fileQnty("5 files")

ddi_origArch("Zentralarchiv fuer empirische Sozialforschung")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/setAvail.html}{setAvail documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/accsPlac.html}{accsPlac documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/avlStatus.html}{avlStatus documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/collSize.html}{collSize documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/complete.html}{complete documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/fileQnty.html}{fileQnty documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/origArch.html}{origArch documentation}
}
