% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rddensity.R
\name{rddensity}
\alias{rddensity}
\title{Manipulation Testing using Local-Polynomial Density Estimation}
\usage{
rddensity(X, c = 0, p = 2, q = 0, kernel = "", fitselect = "",
  h = c(), bwselect = "", vce = "", all = FALSE)
}
\arguments{
\item{X}{Numeric vector or one dimensional matrix / data frame, the running variable.}

\item{c}{Numeric, the cutoff point, default being 0.}

\item{p}{Integer, the order of the local-polynomial used to construct the density
point estimators, with default beign 2. Should be between 1 and 7.}

\item{q}{Integer, the order of the local-polynomial used to construct the bias-corrected
density point estimators. Should be larger than \code{p} (when set to the
default 0, it will be \code{p+1}).}

\item{kernel}{String, the kernel function, can be \code{triangular} (default),
\code{uniform} or \code{epanechnikov}.}

\item{fitselect}{String, either the \code{unrestricted} or the \code{restricted} model
(when set to the default, the unrestricted model will be used).}

\item{h}{Numeric, the bandwidths to the left and right of cutoff for the manipulation test
(when set to the default, the \code{\link{rdbwdensity}} command will be used to
compute data driven bandwidths). If only one numeric value is provided, it will be used
as the common bandwidth. Note that in the restricted model, the two
bandwidths should be the same.}

\item{bwselect}{String, the bandwidth selection method, could be \code{each}, \code{sum},
\code{diff} or \code{comb} (default is \code{comb}). This argument will only be effective
if at least one bandwidth is unspecified by the user. Also in the restricted model, the
\code{each} option is not allowed.}

\item{vce}{String, the standard error estimator, could be \code{plugin} (default) or
\code{jackknife}. When the bandwidths are not specified by the user, this argument will
also affect the bandwidth selection.}

\item{all}{Boolean, whether test based on conventional method (i.e. without bias correction)
should be conducted (default is \code{FALSE}).}
}
\value{
\item{hat}{\code{left}/\code{right}: density estimate to the left/right of cutoff; \code{diff}: difference in
  estimated densities on the two sides of cutoff.}
\item{sd_asy}{\code{left}/\code{right}: standard error for the estimated density to the left/right of the
  cutoff; \code{diff}: standard error for the difference in estimated densities. (Based on
  asymptotic formula.)}
\item{sd_jk}{\code{left}/\code{right}: standard error for the estimated density to the left/right of the
  cutoff; \code{diff}: standard error for the difference in estimated densities. (Based on the
  jackknife method.)}
\item{test}{\code{t_asy}/\code{t_jk}: t-statistic for the density discontinuity test, with standard error
  based on asymptotic formula or the jackknife; \code{p_asy}/\code{p_jk}: p-value for the density
  discontinuity test, with standard error based on asymptotic formula or the jackknife.}
\item{hat_p}{Same as \code{hat}, without bias correction (only available when \code{all=TRUE}).}
\item{sd_asy_p}{Same as \code{sd_asy}, without bias correction (only available when \code{all=TRUE}).}
\item{sd_jk_p}{Same as \code{sd_jk}, without bias correction (only available when \code{all=TRUE}).}
\item{test_p}{Same as \code{test}, without bias correction (only available when \code{all=TRUE}).}
\item{N}{\code{full}: full sample size; \code{left}/\code{right}: sample size to the left/right of the cutoff;
  \code{eff_left}/\code{eff_right}: effective sample size to the left/right of the cutoff (this depends
  on the bandwidth).}
\item{h}{\code{left}/\code{right}: bandwidth used to the left/right of the cutoff.}
\item{opt}{Collects the options used, includes: \code{fitselect}, \code{kernel}, \code{bwselectl},
  \code{bwselect}, \code{hscale}, \code{vce}, \code{c}, \code{p}, \code{q}, \code{all}.
  See options for \code{rddensity}.}
\item{X_min}{\code{left}/\code{right}: the samllest observation to the left/right of the cutoff.}
\item{X_max}{\code{left}/\code{right}: the largest observation to the left/right of the cutoff.}
}
\description{
\code{rddensity} implements manipulation testing procedures using the local
  polynomial density estimators proposed in Cattaneo, Jansson and Ma (2017a).
}
\details{
Companion command: \code{\link{rdbwdensity}} for data-driven bandwidth selection.
  A detailed introduction to this command is given in Cattaneo, Jansson and Ma (2017a).
  A companion \code{Stata} package is described in Cattaneo, Jansson and Ma (2017b).
}
\examples{
# density being continuous
x <- rnorm(1000)
example <- rddensity(X = x, vce="jackknife")
summary(example)
# density being discontinuous
x[x>0] <- x[x>0] * 2
example <- rddensity(X = x, vce="jackknife")
summary(example)
}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017a).  \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Regression Distribution Estimators}. Working Paper, University of Michigan.

M. D. Cattaneo, M. Jansson and X. Ma. (2017b). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_Stata.pdf}{rddensity: Manipulation Testing based on Density Discontinuity}. Working Paper, University of Michigan.
}
\seealso{
\code{\link{rdbwdensity}}
}
\author{
Matias D. Cattaneo, University of Michigan.  \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley.  \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
