% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_sens_cutoff.R
\name{mrd_sens_cutoff}
\alias{mrd_sens_cutoff}
\title{Cutoff Sensitivity Simulation for Multivariate Regression Discontinuity}
\usage{
mrd_sens_cutoff(object, cutoffs)
}
\arguments{
\item{object}{An object returned by \code{mrd_est} or \code{mrd_impute}.}

\item{cutoffs}{A two-column numeric matrix of paired cutoff values 
to be used for refitting an \code{mrd} object. The first column corresponds
to cutoffs for \code{x1} and the second column corresponds to cutoffs
for \code{x2}.}
}
\value{
\code{mrd_sens_cutoff} returns a dataframe containing the estimate \code{est} and standard error \code{se} 
  for each pair of cutoffs (\code{A1} and \code{A2}) and for each \code{model}. \code{A1} contains varying cutoffs 
  for assignment 1 and \code{A2} contains varying cutoffs for assignment 2.
  The \code{model} column contains the approach (either centering, univariate 1, or univariate 2)
  for determining the cutoff and the parametric model (linear, quadratic, or cubic) or 
  non-parametric bandwidth setting (Imbens-Kalyanaraman 2012 optimal, half, or double) used for estimation.
}
\description{
\code{mrd_sens_cutoff} refits the supplied model with varying cutoff(s). 
All other aspects of the model, such as the automatically calculated bandwidth, are held constant.
}
\examples{
set.seed(12345)
x1 <- runif(10000, -1, 1)
x2 <- rnorm(10000, 10, 2)
cov <- rnorm(10000)
y <- 3 + 2 * x1 + 1 * x2 + 3 * cov + 10 * (x1 >= 0) + 5 * (x2 >= 10) + rnorm(10000)
# front.bw arugment was supplied to speed up the example
# users should choose appropriate values for front.bw
mrd <- mrd_est(y ~ x1 + x2 | cov,
               cutpoint = c(0, 10), t.design = c("geq", "geq"), front.bw = c(1,1,1))
mrd_sens_cutoff(mrd, expand.grid(A1 = seq(-.5, .5, length.out = 3), A2 = 10))
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.
}
