\name{kernelwts}
\alias{kernelwts}
\title{Kernel Weighting function}
\usage{
  kernelwts(X, center, bw, kernel = "triangular")
}
\arguments{
  \item{X}{input x values. This variable represents the
  axis along which kernel weighting should be performed.}

  \item{center}{the point from which distances should be
  calculated.}

  \item{bw}{the bandwidth.}

  \item{kernel}{a string indicating the kernel to use.
  Options are \code{"triangular"} (the default),
  \code{"epanechnikov"}, \code{"quartic"},
  \code{"triweight"}, \code{"tricube"}, \code{"gaussian"},
  and \code{"cosine"}.}
}
\value{
  A vector of weights with length equal to that of the
  \code{X} input (one weight per element of \code{X}).
}
\description{
  This function will calculate the appropriate kernel
  weights for a vector. This is useful when, for instance,
  one wishes to perform local regression.
}
\examples{
require(graphics)

X<-seq(-1,1,.01)
triang.wts<-kernelwts(X,0,1,kernel="triangular")
plot(X,triang.wts,type="l")

cos.wts<-kernelwts(X,0,1,kernel="cosine")
plot(X,cos.wts,type="l")
}
\author{
  Drew Dimmery <\email{drewd@nyu.edu}>
}

