% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdacca.mhp.r
\name{rdacca.mhp}
\alias{rdacca.mhp}
\title{Hierarchical Partitioning for Canonical Analysis by Explanatory Matrices}
\usage{
rdacca.mhp(
  dv,
  iv,
  method = c("RDA", "dbRDA", "CCA"),
  type = c("adjR2", "R2"),
  trace = FALSE,
  plot.perc = FALSE
)
}
\arguments{
\item{dv}{Data frame or matrix containing the response data table or dissimilarity structure inheriting from dist. In community ecology, that table is often a site-by-species table or a dissimilarity object.}

\item{iv}{A list containing N groups explanatory data frame or matrix.}

\item{method}{The type of canonical analysis: RDA, dbRDA or CCA, the default is "RDA".}

\item{type}{The type of total explained variation: "adjR2" is adjusted R-squared and "R2" for unadjusted R-squared, the default is "adjR2".}

\item{trace}{logical value, if TRUE, the vaules of commonality (2^N-1for N group of explanatory variables) are outputed,the default is FALSE.}

\item{plot.perc}{logical value, if TRUE, the bar plot (based on ggplot2) of the percentage to independent effects of variables group to total Rsquared, the default is FALSE to show plot with original independent effects.}
}
\value{
a list containing

\item{Method_Type}{The type of canonical analysis and the type of total explained variation.}

\item{R.squared}{The explained variation for global model.}

\item{Commonality}{If trace=TRUE,a mtrix listing tha value and percentage of all commonality (2^N-1 for N explanatory variables groups).}

\item{Var.part}{A matrix listing independent effect and its percentage to total explained variation for each explanatory variable group.}
}
\description{
Hierarchical Partitioning for Canonical Analysis by Explanatory Matrices
}
\details{
This function calculates the independent contribution of each explanatory group to explained variation (R-squared) on canonical analysis (RDA,CCA and dbRDA),
applying the hierarchy algorithm of Chevan and Sutherland (1991). The algorithm is that all joint R-squared will be decomposed into equal fractions by number
of involved explanatory groups and average assigned to these group. Independent R-squared of each variable will be the sum of assigned R-squared from joint R-squared and unique R-squared.
}
\examples{
require(vegan)
data(mite)
data(mite.env)
data(mite.xy)
data(mite.pcnm)
mite.hel <- decostand(mite, "hellinger")
iv <- list(env=mite.env,xy=mite.xy,pcnm=mite.pcnm)
rdacca.mhp(mite.hel,iv,method="RDA",trace = TRUE,plot.perc = FALSE)
rdacca.mhp(vegdist(mite),iv,method="dbRDA",trace = TRUE,plot.perc = FALSE)
rdacca.mhp(mite,iv,method="CCA",trace = TRUE,plot.perc = FALSE)
}
\author{
{Jiangshan Lai} \email{lai@ibcas.ac.cn}

{Pedro Peres-Neto} \email{pedro.peres-neto@concordia.ca}
}
