% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_journals.r
\name{cr_journals}
\alias{cr_journals}
\alias{cr_journals_}
\title{Search CrossRef journals}
\usage{
cr_journals(issn = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", ...)

cr_journals_(issn = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", parse = FALSE, ...)
}
\arguments{
\item{issn}{One or more ISSN's. Format is XXXX-XXXX.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter, 
the rows and offset parameters are ignored. Ignored unless \code{works=TRUE}}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed, 
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Default: \code{FALSE}}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used. 
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search CrossRef journals
}
\details{
BEWARE: The API will only work for CrossRef DOIs.

Note that some parameters are ignored unless \code{works=TRUE}: sample, sort,
order, filter
}
\examples{
\dontrun{
cr_journals(issn="2167-8359")
cr_journals()
cr_journals(issn="2167-8359", works=TRUE)
cr_journals(issn=c('1803-2427','2326-4225'))
cr_journals(query="ecology")
cr_journals(issn="2167-8359", query='ecology', works=TRUE, sort='score', order="asc")
cr_journals(issn="2167-8359", query='ecology', works=TRUE, sort='score', order="desc")
cr_journals(issn="2167-8359", works=TRUE, filter=c(from_pub_date='2014-03-03'))
cr_journals(query="peerj")
cr_journals(issn='1803-2427', works=TRUE)
cr_journals(issn='1803-2427', works=TRUE, sample=1)
cr_journals(limit=2)

# Use the cursor for deep paging
cr_journals(issn='1932-6203', works = TRUE, cursor = "*", cursor_max = 500, limit = 100)
cr_journals(c('1932-6203', '0028-0836'), works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)

# fails, if you want works, you must give an ISSN
# cr_journals(query = "ecology", filter=c(has_full_text = TRUE), works = TRUE)

# Low level function - does no parsing to data.frame, get json or a list
cr_journals_(query = 'ecology')
cr_journals_("2167-8359")
cr_journals_(query = 'ecology', parse=TRUE)
cr_journals_("2167-8359", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
cr_journals_("2167-8359", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100, parse = TRUE)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

