# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simple rcpptimer example
#'
#' Time the computation of Fibonacci numbers
#'
#' @details
#' The function being timed is the following:
#'
#' \code{int fib(int n) { return ((n <= 1) ? n : fib(n - 1) + fib(n - 2)); }}
#'
#' Runtime for computations less than \code{n = 15} is nearly unmeasurable.
#'
#' @param n vector giving integers for which to compute the Fibonacci sum
#' @return vector of integers giving the Fibonacci sum for each element in
#' \code{n}
#' @export
#' @examples
#' \donttest{
#' fibonacci(n = rep(10*(1:4), 10))
#' # this function creates a global environment variable "times"
#' times
#' }
fibonacci <- function(n) {
    .Call(`_rcpptimer_fibonacci`, n)
}

#' Simple rcpptimer example using OpenMP
#'
#' Time the multithreaded computation of Fibonacci numbers
#'
#' @details
#' The function being timed is the following:
#'
#' \code{int fib(int n) { return ((n <= 1) ? n : fib(n - 1) + fib(n - 2)); }}
#'
#' Runtime for computations less than \code{n = 15} is nearly unmeasurable.
#'
#' @param n vector giving integers for which to compute the Fibonacci sum
#' @return vector of integers giving the Fibonacci sum for each element in
#' \code{n}
#' @export
#' @examples
#' \donttest{
#' fibonacci_omp(n = rep(10*(1:4), 10))
#' # this function creates a global environment variable "times"
#' times
#' }
fibonacci_omp <- function(n) {
    .Call(`_rcpptimer_fibonacci_omp`, n)
}

