% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{window.HPDataFrame}
\alias{window.HPDataFrame}
\title{Get a sub window from a \code{\link{HPDataFrame}}}
\usage{
\method{window}{HPDataFrame}(x, new.window, intersect = TRUE, healpixCentered = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{HPDataFrame}}.}

\item{new.window}{Optional.
A single \code{\link{CMBWindow}} object or a list of them.}

\item{intersect}{A boolean that determines
the behaviour when \code{new.window} is a list containing BOTH
regular type and "minus" type windows together (see details).}

\item{healpixCentered}{A boolean. If the HPDataFrame has columns x,y,z
or theta, phi then these will be used to determine locations
with priority over the HEALPix indices in \code{pix(x)}
unless \code{healpixCentered = TRUE} is given. Note that
if \code{healpixCentered = TRUE} then columns x,y,z or theta, phi
will be discarded and replaced with pixel center locations.}

\item{...}{Unused arguments.}
}
\value{
A HPDataFrame containing the data in \code{x} restricted to the
CMBWindow \code{new.window}. Or, if \code{new.window} is
unspecified, then the window attribute of \code{x}
is returned instead (and may be NULL).
}
\description{
This function returns a
HPDataFrame containing the data in \code{hpdf} restricted to the
CMBWindow \code{new.window}. If the HPDataFrame has columns x,y,z
or theta, phi then these will be used to determine locations
with priority over the HEALPix indices in \code{pix(hpdf)}
unless \code{healpixCentered = TRUE} is given. Note that
if \code{healpixCentered = TRUE} then columns x,y,z or theta, phi
will be discarded and replaced with pixel center locations.
}
\details{
Windows that are tagged with \code{set.minus} (see \code{\link{CMBWindow}})
are treated differently from other windows.

If the argument is a list of CMBWindows, then interiors of all windows whose
winType does not include "minus" are united (let \eqn{A} be their union) and
exteriors of all windows whose winType does include "minus" are intersected,
(let \eqn{B} be their intersection). Then, provided that
\code{intersect = TRUE} (the default), the returned data.frame will
be the points of \code{df} in the the intersection of
\eqn{A} and \eqn{B}.
Otherwise, if \code{intersect = FALSE}, the returned data.frame
consists of the points of \code{df} in the union of
\eqn{A} and \eqn{B}.

Note that if \eqn{A} (resp. \eqn{B}) is empty then the returned data.frame
will be the points of \code{df} in \eqn{B} (resp. \eqn{A}).
}
\examples{
ns <- 16
hpdf <- HPDataFrame(nside = ns, I = 1:(12*ns^2))
hpdf

win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
plot(hpdf); plot(win1)

hpdf.win <- window(hpdf, new.window = win1)
plot(hpdf.win, col = "yellow", size = 4, add = TRUE)
attributes(hpdf.win)
window(hpdf.win)
hpdf.win


}
