% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Downloaders.R
\name{downloadCMBPS}
\alias{downloadCMBPS}
\title{Download CMB Power Spectra from Planck Legacy Archive.}
\usage{
downloadCMBPS(link = 1, destfile, save = TRUE)
}
\arguments{
\item{link}{The link code (an integer from 1 to 6) for the URL to
download the file. See code details in this help file.}

\item{destfile}{A character string with the file name for the downloaded
file  to be saved. Tilde-expansion is performed.}

\item{save}{A boolean indicating whether to save or not
(since the downloaded
data is returned anyway).}
}
\value{
The Data Frame with CMB Power Spectra and,
if \code{save = TRUE} a txt file is saved in \code{destfile}
}
\description{
The function \code{downloadCMBPS} downloads
CMB power spectra components from
 \url{https://pla.esac.esa.int/pla/#cosmology}.
}
\details{
\code{link = 1}: Best-fit LCDM CMB power spectra
from the baseline Planck
 TT, TE, EE+lowE+lensing (2 <= ell <= 2508).

\code{link = 2}: Baseline high-ell
Planck TT power spectra (2 <= ell <= 2508).

\code{link = 3}: Baseline high-ell
Planck EE power spectra (2 <= ell <= 1996).

\code{link = 4}: Baseline high-ell
Planck TE power spectra (2 <= ell <= 1996).

\code{link = 5}: Low-ell
Planck EB power spectra (2 <= ell <= 29).

\code{link = 6}: Low-ell
Planck BB power spectra (2 <= ell <= 29).
}
\examples{
## Download the Low-ell Planck BB power spectra (2 <= ell <= 29) and
## save it to C:/PW.txt
# downloadCMBPS(link=6, destfile="C:/PW.txt")

## Download the Best-fit LCDM CMB power spectra
## and plot it
# CMBPS <- downloadCMBPS(link=1, save = FALSE)
# plot(CMBPS$L,CMBPS$TT, type="o",col="red",cex=0.3,
#      main="CMB Angular Power Spectra",xlab=expression(l),
#      ylab=expression(paste(D[l],"(",mu,K^2,")")))


}
\references{
Planck Legacy Archive
\url{https://pla.esac.esa.int/pla/#cosmology}
}
