% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{fmf}
\alias{fmf}
\title{First Minkowski functional}
\usage{
fmf(cmbdf, alpha, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{alpha}{A numeric threshold level.}

\item{intensities}{A \code{\link{CMBDataFrame}} column with measured values.}
}
\value{
The area of the exceedance region
}
\description{
This function returns an area of the spherical region
where measured values
are above of the specified threshold level \eqn{alpha}.
}
\examples{

n <- 64
cmbdf <- CMBDataFrame(nside=n, I = rnorm(12*n^2),
                      coords = "cartesian",
                      ordering = "nested")
fmf(cmbdf, 0, 4)
fmf(cmbdf, 2, 4)

win <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
cmbdf.win <- window(cmbdf, new.window = win)
fmf(cmbdf.win, 0, 4)

}
\references{
Leonenko N., Olenko A. (2014) Sojourn measures of Student
and Fisher-Snedecor random fields.  Bernoulli, 20:1454-1483.
}
