% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_contributing.R
\name{add_contributing}
\alias{add_contributing}
\title{Add contribution guidelines}
\usage{
add_contributing(
  email = NULL,
  organisation = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{email}{A character of length 1. The email address of the project
maintainer.}

\item{organisation}{A character of length 1. The name of the GitHub
organisation to host the package. If \code{NULL} (default) the GitHub account
will be used. This argument is used to set the URL of the package
(hosted on GitHub).}

\item{open}{A logical value. If \code{TRUE} (default) the \code{CONTRIBUTING.md} file
is opened in the editor.}

\item{overwrite}{A logical value. If files are already present and
\code{overwrite = TRUE}, they will be erased and replaced. Default is \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates several files to help the user to learn how to
contribute to the project:
\itemize{
\item \code{CONTRIBUTING.md}: general guidelines outlining the best way to contribute
to the project (can be modified);
\item \code{.github/ISSUE_TEMPLATE/bug_report.md}: an issue template to report a bug
(can be modified);
\item \code{.github/ISSUE_TEMPLATE/feature_request.md}: an issue template to suggest
a new feature (can be modified);
\item \code{.github/ISSUE_TEMPLATE/other_issue.md}: an issue template for all other
types of issue (can be modified).
}
}
\examples{
\dontrun{
add_contributing()
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_code_of_conduct}()},
\code{\link{add_compendium}()},
\code{\link{add_description}()},
\code{\link{add_dockerfile}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_renv}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
