% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_package.R
\name{new_package}
\alias{new_package}
\title{Create an R package structure}
\usage{
new_package(
  license = "GPL (>= 2)",
  status = "concept",
  lifecycle = "experimental",
  vignette = TRUE,
  test = TRUE,
  create_repo = TRUE,
  private = FALSE,
  gh_check = TRUE,
  codecov = TRUE,
  website = TRUE,
  gh_render = TRUE,
  given = NULL,
  family = NULL,
  email = NULL,
  orcid = NULL,
  organisation = NULL,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{license}{A character vector of length 1. The license to be used for
this package. Run \code{\link[=get_licenses]{get_licenses()}} to choose an appropriate one.
Default is \code{license = 'GPL (>= 2)'}

The license can be changed later by calling \code{\link[=add_license]{add_license()}} (and
\code{\link[=add_license_badge]{add_license_badge()}} or \code{\link[=refresh]{refresh()}} to update the corresponding badge in
the README).}

\item{status}{A character vector of length 1. The status of the project
according to the standard defined by the  \url{https://www.repostatus.org}
project. One among \code{'concept'} (default), \code{'wip'}, \code{'suspended'},
\code{'abandoned'}, \code{'active'}, \code{'inactive'}, or \code{'unsupported'}.
See \code{\link[=add_repostatus_badge]{add_repostatus_badge()}} for further information.

This argument is used to add a badge to the \code{README.Rmd} to help visitors
to better understand your project. If you don't want this badge use
\code{status = NULL}.

This status can be added/changed later by using \code{\link[=add_repostatus_badge]{add_repostatus_badge()}}.}

\item{lifecycle}{A character vector of length 1. The life cycle stage of the
project according to the standard defined at
\url{https://lifecycle.r-lib.org/articles/stages.html}. One among
\code{'experimental'} (default), \code{'stable'}, \code{'deprecated'}, or \code{'superseded'}.
See \code{\link[=add_lifecycle_badge]{add_lifecycle_badge()}} for further information.

This argument is used to add a badge to the \code{README.Rmd} to help visitors
to better understand your project. If you don't want this badge use
\code{lifecycle = NULL}.

This stage can be added/changed later by using \code{\link[=add_lifecycle_badge]{add_lifecycle_badge()}}.}

\item{vignette}{A logical value. If \code{TRUE} (default) creates a vignette in
\verb{vignettes/}. Packages \href{https://yihui.org/knitr/}{\code{knitr}} and
\href{https://rmarkdown.rstudio.com/}{\code{rmarkdown}} are also added to the
\code{Suggests} field in the \code{DESCRIPTION} file.}

\item{test}{A logical value. If \code{TRUE} (default) initializes units tests by
running \code{\link[usethis:use_testthat]{usethis::use_testthat()}}. Package
\href{https://testthat.r-lib.org}{\code{testthat}} is also added to the \code{Suggests}
field in the \code{DESCRIPTION} file.}

\item{create_repo}{A logical value. If \code{TRUE} (default) creates a repository
(public if \code{private = FALSE} or private if \code{private = TRUE}) on GitHub.
See below the section \strong{Creating a GitHub repo}.}

\item{private}{A logical value. If \code{TRUE} creates a private repository on
user GitHub account (or organisation). Default is \code{private = FALSE}.}

\item{gh_check}{A logical value. If \code{TRUE} (default) configures GitHub
Actions to automatically check and test the package after each push. This
will run \verb{R CMD check} on the three major operating systems (Ubuntu, macOS,
and Windows) on the latest release of R. See \code{\link[=add_github_actions_check]{add_github_actions_check()}}
for further information.

If \code{create_repo = FALSE} this argument is ignored.}

\item{codecov}{A logical value. If \code{TRUE} (default) configures GitHub
Actions to automatically report the code coverage of units tests after
each push. See \code{\link[=add_github_actions_codecov]{add_github_actions_codecov()}} for further information.

If \code{create_repo = FALSE} this argument is ignored.}

\item{website}{A logical value. If \code{TRUE} (default) configures GitHub
Actions to automatically build and deploy the package website
(using \href{https://pkgdown.r-lib.org/index.html}{\code{pkgdown}})
after each push. A \strong{gh-pages} branch will be created using
\code{\link[usethis:use_github_pages]{usethis::use_github_pages()}} and the GitHub repository will be
automatically configured to deploy website.

If \code{create_repo = FALSE} this argument is ignored.}

\item{gh_render}{A logical value. If \code{TRUE} (default) configures GitHub
Actions to automatically knit the \code{README.Rmd} after each push.
See \code{\link[=add_github_actions_render]{add_github_actions_render()}} for further information.

If \code{create_repo = FALSE} this argument is ignored.}

\item{given}{A character vector of length 1. The given name of the
maintainer of the package. If \code{NULL} (default) the function will try to
get this value by reading the \code{.Rprofile} file.

For further information see \code{\link[=set_credentials]{set_credentials()}} and below the section
\strong{Managing credentials}.}

\item{family}{A character vector of length 1. The family name of the
maintainer of the package. If \code{NULL} (default) the function will try to
get this value by reading the \code{.Rprofile} file.

For further information see \code{\link[=set_credentials]{set_credentials()}} and below the section
\strong{Managing credentials}.}

\item{email}{A character vector of length 1. The email address of the
maintainer of the package. If \code{NULL} (default) the function will try to
get this value by reading the \code{.Rprofile} file.

For further information see \code{\link[=set_credentials]{set_credentials()}} and below the section
\strong{Managing credentials}.}

\item{orcid}{A character vector of length 1. The ORCID of the maintainer of
the package. If \code{NULL} (default) the function will try to get this value
by reading the \code{.Rprofile} file.

For further information see \code{\link[=set_credentials]{set_credentials()}} and below the section
\strong{Managing credentials}.}

\item{organisation}{A character vector of length 1. The GitHub organisation
to host the repository. If defined it will overwrite the GitHub pseudo.

Default is \code{organisation = NULL} (the GitHub pseudo will be used).}

\item{overwrite}{A logical value. If \code{TRUE} files written from templates and
modified by user are erased. Default is \code{overwrite = FALSE}.
\strong{Be careful while using this argument}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates a new R package structure according to the current
best practices.
Essential features of an R package are created (\code{DESCRIPTION} and
\code{NAMESPACE} files, and \verb{R/} and \verb{man/} folders). The project is also
\strong{versioned with git} and a generic R \code{.gitignore} is added.

\strong{IMPORTANT -} Before using this function user needs to create a new folder
(or a new project if using RStudio) and run this function inside this folder
(by using \code{\link[=setwd]{setwd()}} or by opening the \code{Rproj} in a new RStudio session).
\strong{The name of the package will be the same as the name of this folder}.
Some rules must be respected:
\url{https://r-pkgs.org/workflow101.html#name-your-package}.

Some fields of the \code{DESCRIPTION} file (maintainer information, package name,
license, URLs, and  \code{roxygen2} version)  are automatically filled but
others (like title and description) need to be edited manually.

Additional features are also created: a \code{CITATION} file, a \code{README.Rmd}, and
\verb{tests/} and \verb{vignettes/} folders (optional). See the vignette
\href{https://frbcesab.github.io/rcompendium/articles/rcompendium.html}{Get started}
for a complete overview of the full structure.

A GitHub repository can also be created (default) following the
"GitHub last" workflow
(\url{https://happygitwithr.com/existing-github-last.html}).
Configuration files for GitHub Actions to automatically 1) check the
package, 2) test and report code coverage, and 3) deploy the website using
\href{https://pkgdown.r-lib.org/index.html}{\code{pkgdown}}
will be added in the \verb{.github/} folder. See below the section
\strong{Creating a GitHub repo}.
}
\section{Recommended workflow}{


The purpose of the package \code{rcompendium} is to make easier the creation of R
package/research compendium so that user can focus on the code/analysis
instead of wasting time organizing files.

The recommended workflow is:
\enumerate{
\item Create an empty RStudio project;
\item Store your credentials with \code{\link[=set_credentials]{set_credentials()}} (if not already done);
\item Run \code{\link[=new_package]{new_package()}} to create a new package structure (and the GitHub
repository);
\item Edit some metadata in \code{DESCRIPTION}, \code{CITATION}, and \code{README.Rmd};
\item Implement, document & test functions (the fun part);
\item Update the project (update \code{.Rd} files, \code{NAMESPACE}, external
dependencies in \code{DESCRIPTION}, re-knit \code{README.Rmd}, and check package
integrity) with \code{\link[=refresh]{refresh()}};
\item Repeat steps 5 and 6 while developing the package.
}
}

\section{Managing credentials}{


You can use the arguments \code{given}, \code{family}, \code{email}, and \code{orcid}
directly with the function \code{\link[=new_package]{new_package()}} (and others). But if you create
a lot a projects (packages and/or compendiums) it can be frustrating in the
long run.

An alternative is to use \strong{ONCE AND FOR ALL} the function
\code{\link[=set_credentials]{set_credentials()}} to permanently store this information in the
\code{.Rprofile} file. If these arguments are set to \code{NULL} (default) each
function of the package \code{rcompendium} will search in this \code{.Rprofile} file.
It will save your time (it's the purpose of this package).

Even if you have stored your information in the \code{.Rprofile} file you will
always be able to modify them on-the-fly (i.e. by using arguments of the
\code{\link[=new_package]{new_package()}}) or permanently by re-running \code{\link[=set_credentials]{set_credentials()}}.
}

\section{Configuring git}{


First run \code{\link[gh:gh_whoami]{gh::gh_whoami()}} to see if your git is correctly configured. If
so you should see something like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "name": "John Doe",
  "login": "jdoe",
  "html_url": "https://github.com/jdoe",
  ...
\}
}\if{html}{\out{</div>}}

Otherwise you might need to run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gert::git_config_global_set(name  = "user.name", 
                            value = "John Doe")
                            
gert::git_config_global_set(name  = "user.email", 
                            value = "john.doe@domain.com")
                            
gert::git_config_global_set(name  = "github.user", 
                            value = "jdoe")
}\if{html}{\out{</div>}}

See \code{\link[gert:git_config]{gert::git_config_global_set()}} for further information.
}

\section{Creating a GitHub repo}{


To create the GitHub repository directly from R, the package \code{rcompendium}
uses the function \code{\link[usethis:use_github]{usethis::use_github()}}, an client to the GitHub REST API.
The interaction with this API required an authentication method: a
\strong{GITHUB PAT} (Personal Access Token).

If you don't have a \strong{GITHUB PAT} locally stored, you must:
\enumerate{
\item Obtain a new one from your GitHub account. \strong{Make sure to select
at least the first two scopes (private repository and workflow)}
\item Store it in the \verb{~/.Renviron} file by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}
and adding the following line: \code{GITHUB_PAT='ghp_99z9...z9'}
}

Run \code{\link[usethis:github-token]{usethis::gh_token_help()}} for more information about getting and
configuring a \strong{GITHUB PAT}.

If everything is well configured you should see something like this after
calling \code{\link[gh:gh_whoami]{gh::gh_whoami()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "name": "John Doe",
  "login": "jdoe",
  "html_url": "https://github.com/jdoe",
  "scopes": "delete_repo, repo, workflow",
  "token": "ghp_99z9...z9"
\}
}\if{html}{\out{</div>}}

And you will be able to create a GitHub repository directly from R!
}

\examples{
\dontrun{
library(rcompendium)

## Define **ONCE FOR ALL** your credentials ----
set_credentials(given = "John", family = "Doe", 
                email = "john.doe@domain.com", 
                orcid = "9999-9999-9999-9999", protocol = "ssh")

## Create an R package ----
new_package()

## Start developing functions ----
## ...

## Update package (documentation, dependencies, README, check) ----
refresh()
}
}
\seealso{
Other setup functions: 
\code{\link{new_compendium}()},
\code{\link{refresh}()},
\code{\link{set_credentials}()}
}
\concept{setup functions}
