/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import blogspot.software_and_algorithms.stern_library.data_structure.Interval;
import blogspot.software_and_algorithms.stern_library.data_structure.OrderLinkedRedBlackTree;
import blogspot.software_and_algorithms.stern_library.data_structure.RedBlackTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StaticIntervalTree<U extends Comparable<U>, T extends Interval<U>> {
    private Node<U, T> root;
    private int size = 0;

    private Node<U, T> buildSubtree(List<T> intervalList, int low, int high) {
        Object point = ((Interval)intervalList.get(low + high >>> 1)).getLow();
        Node result = new Node(point);
        int lowPointer = low;
        int highPointer = high;
        for (int j = low; j < highPointer; ++j) {
            Interval next = (Interval)intervalList.get(j);
            if (next.getHigh().compareTo(point) < 0) {
                Collections.swap(intervalList, lowPointer++, j);
                continue;
            }
            if (next.getLow().compareTo(point) <= 0) continue;
            highPointer = j;
        }
        if (low < lowPointer) {
            result.setLeft((Node)this.buildSubtree(intervalList, low, lowPointer));
        }
        if (highPointer < high) {
            result.setRight((Node)this.buildSubtree(intervalList, highPointer, high));
        }
        return result;
    }

    public void buildTree(Set<T> intervals) {
        ArrayList<T> intervalList = new ArrayList<T>(intervals);
        Collections.sort(intervalList, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Interval)o1).getLow().compareTo(((Interval)o2).getLow());
            }
        });
        this.root = this.buildSubtree(intervalList, 0, intervals.size());
        this.size = 0;
    }

    public void clear() {
        if (this.root != null) {
            ArrayList stack = new ArrayList();
            stack.add(this.root);
            while (!stack.isEmpty()) {
                Node next = (Node)stack.remove(stack.size() - 1);
                next.clear();
                Node temp = next.getLeft();
                if (temp != null) {
                    stack.add(temp);
                }
                if ((temp = next.getRight()) == null) continue;
                stack.add(temp);
            }
        }
        this.size = 0;
    }

    public boolean delete(T interval) {
        if (interval == null) {
            return false;
        }
        Node<U, T> node = this.root;
        while (node != null) {
            U temp = node.getPoint();
            if (((Interval)interval).getLow().compareTo(temp) <= 0 && temp.compareTo(((Interval)interval).getHigh()) <= 0) {
                if (!node.delete(interval)) continue;
                --this.size;
                return true;
            }
            if (((Interval)interval).getHigh().compareTo(temp) < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return false;
    }

    public <V extends Collection<T>> V fetchContainingIntervals(V target, U queryPoint) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (queryPoint == null) {
            throw new NullPointerException("queryPoint is null");
        }
        Node<U, T> node = this.root;
        while (node != null) {
            U temp = node.getPoint();
            if (queryPoint.equals(temp)) {
                node.fetchIntervalsContainingNodePoint(target);
                node = null;
                continue;
            }
            if (queryPoint.compareTo(temp) < 0) {
                node.fetchIntervalsContainingPointLow(target, queryPoint, true);
                node = node.getLeft();
                continue;
            }
            node.fetchIntervalsContainingPointHigh(target, queryPoint, true);
            node = node.getRight();
        }
        return target;
    }

    public <V extends Collection<T>> V fetchOverlappingIntervals(V target, T queryInterval) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (queryInterval == null) {
            throw new NullPointerException("queryInterval is null");
        }
        ArrayList stack = new ArrayList();
        if (this.root != null) {
            stack.add(this.root);
        }
        while (!stack.isEmpty()) {
            Node node = (Node)stack.remove(stack.size() - 1);
            Object temp = node.getPoint();
            if (((Interval)queryInterval).getLow().compareTo(temp) <= 0 && temp.compareTo(((Interval)queryInterval).getHigh()) <= 0) {
                node.fetchOverlappingIntervals(target, queryInterval);
                if (node.getLeft() != null) {
                    stack.add(node.getLeft());
                }
                if (node.getRight() == null) continue;
                stack.add(node.getRight());
                continue;
            }
            if (((Interval)queryInterval).getHigh().compareTo(temp) < 0) {
                node.fetchIntervalsContainingPointLow(target, ((Interval)queryInterval).getHigh(), ((Interval)queryInterval).isClosedOnHigh());
                if (node.getLeft() == null) continue;
                stack.add(node.getLeft());
                continue;
            }
            node.fetchIntervalsContainingPointHigh(target, ((Interval)queryInterval).getLow(), ((Interval)queryInterval).isClosedOnLow());
            if (node.getRight() == null) continue;
            stack.add(node.getRight());
        }
        return target;
    }

    public int getSize() {
        return this.size;
    }

    public boolean insert(T interval) {
        Node<U, T> node = this.root;
        while (node != null) {
            U temp = node.getPoint();
            if (((Interval)interval).getLow().compareTo(temp) <= 0 && temp.compareTo(((Interval)interval).getHigh()) <= 0) {
                if (!((Node)node).insert(interval)) continue;
                ++this.size;
                return true;
            }
            if (((Interval)interval).getHigh().compareTo(temp) < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return false;
    }

    protected static class Node<U extends Comparable<U>, T extends Interval<U>> {
        private RedBlackTree<T> highOrderedContainingIntervals = new OrderLinkedRedBlackTree(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = ((Interval)o1).getHigh().compareTo(((Interval)o2).getHigh());
                if (result == 0) {
                    result = ((Interval)o1).isClosedOnHigh() != ((Interval)o2).isClosedOnHigh() ? (((Interval)o1).isClosedOnHigh() ? 1 : -1) : ((Interval)o1).compareTo(o2);
                }
                return result > 0 ? -1 : (result < 0 ? 1 : 0);
            }
        });
        private RedBlackTree<T> lowOrderedContainingIntervals = new OrderLinkedRedBlackTree(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = ((Interval)o1).getLow().compareTo(((Interval)o2).getLow());
                if (result == 0) {
                    result = ((Interval)o1).compareTo(o2);
                }
                return result > 0 ? 1 : (result < 0 ? -1 : 0);
            }
        });
        private RedBlackTree<T> highOrderedExcludingIntervals = new OrderLinkedRedBlackTree(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = ((Interval)o1).getHigh().compareTo(((Interval)o2).getHigh());
                if (result == 0) {
                    result = ((Interval)o1).isClosedOnHigh() != ((Interval)o2).isClosedOnHigh() ? (((Interval)o1).isClosedOnHigh() ? 1 : -1) : ((Interval)o1).compareTo(o2);
                }
                return result > 0 ? -1 : (result < 0 ? 1 : 0);
            }
        });
        private RedBlackTree<T> lowOrderedExcludingIntervals = new OrderLinkedRedBlackTree(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = ((Interval)o1).getLow().compareTo(((Interval)o2).getLow());
                if (result == 0) {
                    result = ((Interval)o1).compareTo(o2);
                }
                return result > 0 ? 1 : (result < 0 ? -1 : 0);
            }
        });
        private Node<U, T> left;
        private Node<U, T> right;
        private U point;

        public Node(U point) {
            if (point == null) {
                throw new NullPointerException("point is null");
            }
            this.point = point;
        }

        public void clear() {
            this.lowOrderedContainingIntervals.clear();
            this.highOrderedContainingIntervals.clear();
            this.lowOrderedExcludingIntervals.clear();
            this.highOrderedExcludingIntervals.clear();
        }

        public boolean delete(T interval) {
            if (((Interval)interval).contains(this.point)) {
                if (this.lowOrderedContainingIntervals.delete(interval) == null) {
                    return false;
                }
                this.highOrderedContainingIntervals.delete(interval);
            } else {
                if (this.lowOrderedExcludingIntervals.delete(interval) == null) {
                    return false;
                }
                this.highOrderedExcludingIntervals.delete(interval);
            }
            return true;
        }

        public void fetchIntervalsContainingNodePoint(Collection<T> target) {
            if (this.highOrderedContainingIntervals.getSize() > 0) {
                RedBlackTree.Node<T> temp = this.highOrderedContainingIntervals.getFirstNode();
                while (temp != null) {
                    target.add((Interval)temp.getValue());
                    temp = this.highOrderedContainingIntervals.getSuccessor(temp);
                }
            }
        }

        public void fetchIntervalsContainingPointHigh(Collection<T> target, U queryPoint, boolean isClosedOnValue) {
            Interval next;
            int cmp;
            Iterator<T> i = this.highOrderedContainingIntervals.iterator();
            while (i.hasNext() && (cmp = (next = (Interval)i.next()).getHigh().compareTo(queryPoint)) >= 0 && (cmp != 0 || isClosedOnValue && next.isClosedOnHigh())) {
                target.add(next);
            }
            i = this.highOrderedExcludingIntervals.iterator();
            while (i.hasNext() && (cmp = (next = (Interval)i.next()).getHigh().compareTo(queryPoint)) >= 0 && (cmp != 0 || isClosedOnValue && next.isClosedOnHigh())) {
                target.add(next);
            }
        }

        public void fetchIntervalsContainingPointLow(Collection<T> target, U queryPoint, boolean isClosedOnValue) {
            Interval next;
            int cmp;
            Iterator<T> i = this.lowOrderedContainingIntervals.iterator();
            while (i.hasNext() && (cmp = (next = (Interval)i.next()).getLow().compareTo(queryPoint)) <= 0 && (cmp != 0 || isClosedOnValue && next.isClosedOnLow())) {
                target.add(next);
            }
            i = this.lowOrderedExcludingIntervals.iterator();
            while (i.hasNext() && (cmp = (next = (Interval)i.next()).getLow().compareTo(queryPoint)) <= 0 && (cmp != 0 || isClosedOnValue && next.isClosedOnLow())) {
                target.add(next);
            }
        }

        public void fetchOverlappingIntervals(Collection<T> target, Interval<U> queryInterval) {
            if (queryInterval.getLow().compareTo(this.point) == 0) {
                this.fetchIntervalsContainingPointHigh(target, queryInterval.getLow(), queryInterval.isClosedOnLow());
            } else if (queryInterval.getHigh().compareTo(this.point) == 0) {
                this.fetchIntervalsContainingPointLow(target, queryInterval.getHigh(), queryInterval.isClosedOnHigh());
            } else {
                this.fetchIntervalsContainingNodePoint(target);
                if (this.highOrderedExcludingIntervals.getSize() > 0) {
                    RedBlackTree.Node<T> temp = this.highOrderedExcludingIntervals.getFirstNode();
                    while (temp != null) {
                        target.add((Interval)temp.getValue());
                        temp = this.highOrderedExcludingIntervals.getSuccessor(temp);
                    }
                }
            }
        }

        public Node<U, T> getLeft() {
            return this.left;
        }

        public U getPoint() {
            return this.point;
        }

        public Node<U, T> getRight() {
            return this.right;
        }

        private boolean insert(T interval) {
            if (((Interval)interval).contains(this.point)) {
                if (this.lowOrderedContainingIntervals.insert(interval) == null) {
                    return false;
                }
                this.highOrderedContainingIntervals.insert(interval);
            } else {
                if (this.lowOrderedExcludingIntervals.insert(interval) == null) {
                    return false;
                }
                this.highOrderedExcludingIntervals.insert(interval);
            }
            return true;
        }

        private void setLeft(Node<U, T> node) {
            this.left = node;
        }

        private void setRight(Node<U, T> node) {
            this.right = node;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            Iterator<T> i = this.lowOrderedContainingIntervals.iterator();
            while (true) {
                builder.append(((Interval)i.next()).toString());
                if (!i.hasNext()) break;
                builder.append(", ");
            }
            i = this.lowOrderedExcludingIntervals.iterator();
            while (i.hasNext()) {
                builder.append(", ").append(((Interval)i.next()).toString());
            }
            builder.append("}");
            return builder.toString();
        }
    }
}

