/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.WrappedReifier;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class WrappedGraph
implements GraphWithPerform {
    protected Graph base;
    protected Reifier reifier;
    protected BulkUpdateHandler bud;
    protected GraphEventManager gem;

    public WrappedGraph(Graph base) {
        this.base = base;
        this.reifier = new WrappedReifier(base.getReifier(), this);
    }

    @Override
    public boolean dependsOn(Graph other) {
        return this.base.dependsOn(other);
    }

    @Override
    public QueryHandler queryHandler() {
        return this.base.queryHandler();
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.base.getTransactionHandler();
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bud == null) {
            this.bud = new WrappedBulkUpdateHandler(this, this.base.getBulkUpdateHandler());
        }
        return this.bud;
    }

    @Override
    public GraphStatisticsHandler getStatisticsHandler() {
        return this.base.getStatisticsHandler();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    @Override
    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    @Override
    public Reifier getReifier() {
        return this.reifier;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.base.getPrefixMapping();
    }

    @Override
    public void add(Triple t) {
        this.base.add(t);
        this.getEventManager().notifyAddTriple(this, t);
    }

    @Override
    public void delete(Triple t) {
        this.base.delete(t);
        this.getEventManager().notifyDeleteTriple(this, t);
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(m));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return SimpleEventManager.notifyingRemove(this, this.base.find(s, p, o));
    }

    @Override
    public boolean isIsomorphicWith(Graph g) {
        return this.base.isIsomorphicWith(g);
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.base.contains(s, p, o);
    }

    @Override
    public boolean contains(Triple t) {
        return this.base.contains(t);
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public boolean isClosed() {
        return this.base.isClosed();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public void performAdd(Triple t) {
        this.base.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.base.delete(t);
    }
}

