/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;

abstract class IntSet {
    private static final IntSet UNIVERSE = new IntSet(){

        boolean contains(int x) {
            return true;
        }
    };

    IntSet() {
    }

    abstract boolean contains(int var1);

    static IntSet universe() {
        return UNIVERSE;
    }

    static IntSet empty() {
        return IntSet.complement(IntSet.universe());
    }

    static IntSet allOf(int x, int ... xs) {
        BitSet s = new BitSet();
        s.set(x);
        for (int v : xs) {
            s.set(v);
        }
        return new BinarySet(s);
    }

    static IntSet noneOf(int x, int ... xs) {
        return IntSet.complement(IntSet.allOf(x, xs));
    }

    static IntSet fromBitSet(BitSet s) {
        return new BinarySet((BitSet)s.clone());
    }

    private static IntSet complement(IntSet set) {
        return new Complement(set);
    }

    private static final class Complement
    extends IntSet {
        private final IntSet delegate;

        private Complement(IntSet delegate) {
            this.delegate = delegate;
        }

        boolean contains(int x) {
            return !this.delegate.contains(x);
        }
    }

    private static final class BinarySet
    extends IntSet {
        private final BitSet s;

        private BinarySet(BitSet s) {
            this.s = s;
        }

        boolean contains(int x) {
            return this.s.get(x);
        }
    }
}

