/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.EdmondsMaximumMatching;

@TestClass(value="org.openscience.cdk.graph.MatchingTest")
public final class Matching {
    private static final int Nil = -1;
    private final int[] match;

    private Matching(int n) {
        this.match = new int[n];
        Arrays.fill(this.match, -1);
    }

    @TestMethod(value="match")
    public void match(int u, int v) {
        this.match[u] = v;
        this.match[v] = u;
    }

    @TestMethod(value="other")
    public int other(int v) {
        if (this.unmatched(v)) {
            throw new IllegalArgumentException(v + " is not matched");
        }
        return this.match[v];
    }

    @TestMethod(value="unmatch")
    public void unmatch(int v) {
        this.match[v] = -1;
    }

    @TestMethod(value="nop")
    public boolean matched(int v) {
        return !this.unmatched(v);
    }

    @TestMethod(value="nop")
    public boolean unmatched(int v) {
        return this.match[v] == -1 || this.match[this.match[v]] != v;
    }

    @TestMethod(value="fulvelene2")
    public boolean perfect(int[][] graph, BitSet subset) {
        if (graph.length != this.match.length || subset.cardinality() > graph.length) {
            throw new IllegalArgumentException("graph and matching had different capacity");
        }
        if ((subset.cardinality() & 1) == 1) {
            return false;
        }
        if (this.arbitaryMatching(graph, subset)) {
            return true;
        }
        EdmondsMaximumMatching.maxamise(this, graph, subset);
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            if (this.unmatched(v)) {
                return false;
            }
            v = subset.nextSetBit(v + 1);
        }
        return true;
    }

    @TestMethod(value="perfectArbitaryMatching,imperfectArbitaryMatching")
    boolean arbitaryMatching(int[][] graph, BitSet subset) {
        BitSet unmatched = new BitSet();
        int[] deg = new int[graph.length];
        int[] deg1 = new int[graph.length];
        int nd1 = 0;
        int nMatched = 0;
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            if (this.matched(v)) {
                assert (subset.get(this.other(v)));
                ++nMatched;
            } else {
                unmatched.set(v);
                for (int w : graph[v]) {
                    if (!subset.get(w) || !this.unmatched(w)) continue;
                    int n = v;
                    deg[n] = deg[n] + 1;
                }
                if (deg[v] == 1) {
                    deg1[nd1++] = v;
                }
            }
            v = subset.nextSetBit(v + 1);
        }
        block2: while (!unmatched.isEmpty()) {
            v = -1;
            while (nd1 > 0 && !unmatched.get(v = deg1[--nd1])) {
            }
            if (v < 0 || unmatched.get(v)) {
                v = unmatched.nextSetBit(0);
            }
            unmatched.clear(v);
            for (int w : graph[v]) {
                int u;
                int i$;
                if (!unmatched.get(w)) continue;
                this.match(v, w);
                nMatched += 2;
                unmatched.clear(w);
                int[] arr$ = graph[w];
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    int n = u = arr$[i$];
                    deg[n] = deg[n] - 1;
                    if (deg[n] != 1 || !unmatched.get(u)) continue;
                    deg1[nd1++] = u;
                }
                if (deg[v] <= 1) continue block2;
                arr$ = graph[v];
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    int n = u = arr$[i$];
                    deg[n] = deg[n] - 1;
                    if (deg[n] != 1 || !unmatched.get(u)) continue;
                    deg1[nd1++] = u;
                }
                continue block2;
            }
        }
        return nMatched == subset.cardinality();
    }

    @TestMethod(value="nop")
    public static Matching withCapacity(int capacity) {
        return new Matching(capacity);
    }

    @TestMethod(value="string")
    public String toString() {
        StringBuilder sb = new StringBuilder(4 * this.match.length);
        sb.append('[');
        for (int u = 0; u < this.match.length; ++u) {
            int v = this.match[u];
            if (v <= u || this.match[v] != u) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(u).append('=').append(v);
        }
        sb.append(']');
        return sb.toString();
    }
}

