/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.BondDiff;
import org.openscience.cdk.tools.diff.ChemObjectDiff;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.LonePairDiff;
import org.openscience.cdk.tools.diff.SingleElectronDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

@TestClass(value="org.openscience.cdk.tools.diff.AtomContainerDiffTest")
public class AtomContainerDiff {
    private AtomContainerDiff() {
    }

    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = AtomContainerDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        int i;
        if (!(first instanceof IAtomContainer) || !(second instanceof IAtomContainer)) {
            return null;
        }
        IAtomContainer firstAC = (IAtomContainer)first;
        IAtomContainer secondAC = (IAtomContainer)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("AtomContainerDiff");
        totalDiff.addChild(IntegerDifference.construct("atomCount", firstAC.getAtomCount(), secondAC.getAtomCount()));
        if (firstAC.getAtomCount() == secondAC.getAtomCount()) {
            for (i = 0; i < firstAC.getAtomCount(); ++i) {
                totalDiff.addChild(AtomDiff.difference((IChemObject)firstAC.getAtom(i), (IChemObject)secondAC.getAtom(i)));
            }
        }
        totalDiff.addChild(IntegerDifference.construct("electronContainerCount", firstAC.getElectronContainerCount(), secondAC.getElectronContainerCount()));
        if (firstAC.getElectronContainerCount() == secondAC.getElectronContainerCount()) {
            for (i = 0; i < firstAC.getElectronContainerCount(); ++i) {
                if (firstAC.getElectronContainer(i) instanceof IBond && secondAC.getElectronContainer(i) instanceof IBond) {
                    totalDiff.addChild(BondDiff.difference((IChemObject)firstAC.getElectronContainer(i), (IChemObject)secondAC.getElectronContainer(i)));
                    continue;
                }
                if (firstAC.getElectronContainer(i) instanceof ILonePair && secondAC.getElectronContainer(i) instanceof ILonePair) {
                    totalDiff.addChild(LonePairDiff.difference((IChemObject)firstAC.getElectronContainer(i), (IChemObject)secondAC.getElectronContainer(i)));
                    continue;
                }
                if (firstAC.getElectronContainer(i) instanceof ISingleElectron && secondAC.getElectronContainer(i) instanceof ISingleElectron) {
                    totalDiff.addChild(SingleElectronDiff.difference((IChemObject)firstAC.getElectronContainer(i), (IChemObject)secondAC.getElectronContainer(i)));
                    continue;
                }
                totalDiff.addChild(ElectronContainerDiff.difference((IChemObject)firstAC.getElectronContainer(i), (IChemObject)secondAC.getElectronContainer(i)));
            }
        }
        totalDiff.addChild(ChemObjectDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

