/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Element;

public final class AtomBuilder {
    private final Element element;
    private int isotope = -1;
    private int hCount = 0;
    private int charge = 0;
    private int atomClass = 0;
    private boolean aromatic;

    private AtomBuilder(Element element, boolean aromatic) {
        this.element = element;
        this.aromatic = aromatic;
    }

    public static AtomBuilder aliphatic(Element e) {
        if (e == null) {
            throw new NullPointerException("no element provided");
        }
        return new AtomBuilder(e, false);
    }

    public static AtomBuilder aromatic(Element e) {
        if (e == null) {
            throw new NullPointerException("no element provided");
        }
        if (e == Element.Unknown) {
            return new AtomBuilder(e, false);
        }
        if (!e.aromatic(Element.AromaticSpecification.Daylight)) {
            throw new IllegalArgumentException("The element '" + (Object)((Object)e) + "' cannot be aromatic by the Daylight specification.");
        }
        return new AtomBuilder(e, true);
    }

    public static AtomBuilder aliphatic(String symbol) {
        if (symbol == null) {
            throw new NullPointerException("no symbol provided");
        }
        return AtomBuilder.aliphatic(AtomBuilder.ofSymbolOrUnknown(symbol));
    }

    public static AtomBuilder aromatic(String symbol) {
        if (symbol == null) {
            throw new NullPointerException("no symbol provided");
        }
        return AtomBuilder.aromatic(AtomBuilder.ofSymbolOrUnknown(symbol));
    }

    public static AtomBuilder create(String symbol) {
        Element e = AtomBuilder.ofSymbolOrUnknown(symbol);
        if (symbol != null && !symbol.isEmpty() && Character.isLowerCase(symbol.charAt(0))) {
            if (!e.aromatic()) {
                throw new IllegalArgumentException("Attempting to create an aromatic atom for an element which cannot be aromatic");
            }
            return new AtomBuilder(e, true);
        }
        return new AtomBuilder(e, false);
    }

    private static Element ofSymbolOrUnknown(String symbol) {
        Element e = Element.ofSymbol(symbol);
        return e != null ? e : Element.Unknown;
    }

    public AtomBuilder hydrogens(int hCount) {
        if (hCount < 0) {
            throw new IllegalArgumentException("the number of hydrogens must be positive");
        }
        this.hCount = hCount;
        return this;
    }

    public AtomBuilder charge(int charge) {
        this.charge = charge;
        return this;
    }

    public AtomBuilder anion() {
        return this.charge(-1);
    }

    public AtomBuilder cation() {
        return this.charge(1);
    }

    public AtomBuilder isotope(int isotope) {
        this.isotope = isotope;
        return this;
    }

    public AtomBuilder atomClass(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("atom class must be positive");
        }
        this.atomClass = c;
        return this;
    }

    public Atom build() {
        return new AtomImpl.BracketAtom(this.isotope, this.element, this.hCount, this.charge, this.atomClass, this.aromatic);
    }

    public static Atom explicitHydrogen() {
        return AtomImpl.EXPLICIT_HYDROGEN;
    }
}

