/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;

@TestClass(value="org.openscience.cdk.renderer.elements.BoundingBoxTest")
public final class Bounds
implements IRenderingElement {
    public final double minX;
    public final double minY;
    public final double maxX;
    public final double maxY;

    @TestMethod(value="testConstructor")
    public Bounds(double x1, double y1, double x2, double y2) {
        this.minX = x1;
        this.minY = y1;
        this.maxX = x2;
        this.maxY = y2;
    }

    @TestMethod(value="width")
    public final double width() {
        return this.maxX - this.minX;
    }

    @TestMethod(value="width")
    public final double height() {
        return this.maxY - this.minY;
    }

    @Override
    @TestMethod(value="testAccept")
    public void accept(IRenderingVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "{{" + this.minX + ", " + this.minY + "} - {" + this.maxX + ", " + this.maxY + "}}";
    }
}

