/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.CombinedPermutationParity;
import org.openscience.cdk.hash.stereo.GeometricDoubleBondEncoderFactory;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.hash.stereo.Tetrahedral2DParity;
import org.openscience.cdk.hash.stereo.Tetrahedral3DParity;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.hash.stereo.GeometricCumulativeDoubleBondFactoryTest")
public class GeometricCumulativeDoubleBondFactory
implements StereoEncoderFactory {
    @Override
    @TestMethod(value="testCreate")
    public StereoEncoder create(IAtomContainer container, int[][] graph) {
        int n = container.getAtomCount();
        BondMap map = new BondMap(n);
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>(1);
        for (IBond bond : container.bonds()) {
            if (!GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            map.add(bond);
        }
        HashSet<IAtom> visited = new HashSet<IAtom>(n);
        for (IAtom a : map.atoms()) {
            StereoEncoder encoder;
            IAtom q;
            IAtom p;
            List<IBond> bonds = map.bonds(a);
            if (bonds.size() != 2) continue;
            IAtom s = bonds.get(0).getConnectedAtom(a);
            IAtom e = bonds.get(1).getConnectedAtom(a);
            IAtom sParent = a;
            IAtom eParent = a;
            visited.add(a);
            visited.add(s);
            visited.add(e);
            int size = 2;
            while (s != null && map.cumulated(s)) {
                p = map.bonds(s).get(0).getConnectedAtom(s);
                q = map.bonds(s).get(1).getConnectedAtom(s);
                sParent = s;
                s = visited.add(p) ? p : (visited.add(q) ? q : null);
                ++size;
            }
            while (e != null && map.cumulated(e)) {
                p = map.bonds(e).get(0).getConnectedAtom(e);
                q = map.bonds(e).get(1).getConnectedAtom(e);
                eParent = e;
                e = visited.add(p) ? p : (visited.add(q) ? q : null);
                ++size;
            }
            if (s == null || e == null) continue;
            if (GeometricCumulativeDoubleBondFactory.isOdd(size)) {
                encoder = GeometricDoubleBondEncoderFactory.newEncoder(container, s, sParent, e, eParent, graph);
                if (encoder == null) continue;
                encoders.add(encoder);
                continue;
            }
            encoder = GeometricCumulativeDoubleBondFactory.axialEncoder(container, s, e);
            if (encoder == null) continue;
            encoders.add(encoder);
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    @TestMethod(value="testAxialEncoder_Empty")
    static StereoEncoder axialEncoder(IAtomContainer container, IAtom start, IAtom end) {
        List<IBond> startBonds = container.getConnectedBondsList(start);
        List<IBond> endBonds = container.getConnectedBondsList(end);
        if (startBonds.size() < 2 || endBonds.size() < 2) {
            return null;
        }
        if (GeometricCumulativeDoubleBondFactory.has2DCoordinates(startBonds) && GeometricCumulativeDoubleBondFactory.has2DCoordinates(endBonds)) {
            return GeometricCumulativeDoubleBondFactory.axial2DEncoder(container, start, startBonds, end, endBonds);
        }
        if (GeometricCumulativeDoubleBondFactory.has3DCoordinates(startBonds) && GeometricCumulativeDoubleBondFactory.has3DCoordinates(endBonds)) {
            return GeometricCumulativeDoubleBondFactory.axial3DEncoder(container, start, startBonds, end, endBonds);
        }
        return null;
    }

    private static StereoEncoder axial2DEncoder(IAtomContainer container, IAtom start, List<IBond> startBonds, IAtom end, List<IBond> endBonds) {
        Point2d[] ps = new Point2d[4];
        int[] es = new int[4];
        CombinedPermutationParity perm = new CombinedPermutationParity(GeometricCumulativeDoubleBondFactory.fill2DCoordinates(container, start, startBonds, ps, es, 0), GeometricCumulativeDoubleBondFactory.fill2DCoordinates(container, end, endBonds, ps, es, 2));
        Tetrahedral2DParity geom = new Tetrahedral2DParity(ps, es);
        int u = container.getAtomNumber(start);
        int v = container.getAtomNumber(end);
        return new GeometryEncoder(new int[]{u, v}, (PermutationParity)perm, (GeometricParity)geom);
    }

    private static StereoEncoder axial3DEncoder(IAtomContainer container, IAtom start, List<IBond> startBonds, IAtom end, List<IBond> endBonds) {
        Point3d[] coordinates = new Point3d[4];
        CombinedPermutationParity perm = new CombinedPermutationParity(GeometricCumulativeDoubleBondFactory.fill3DCoordinates(container, start, startBonds, coordinates, 0), GeometricCumulativeDoubleBondFactory.fill3DCoordinates(container, end, endBonds, coordinates, 2));
        Tetrahedral3DParity geom = new Tetrahedral3DParity(coordinates);
        int u = container.getAtomNumber(start);
        int v = container.getAtomNumber(end);
        return new GeometryEncoder(new int[]{u, v}, (PermutationParity)perm, (GeometricParity)geom);
    }

    private static PermutationParity fill2DCoordinates(IAtomContainer container, IAtom a, List<IBond> connected, Point2d[] coordinates, int[] elevations, int offset) {
        int i = 0;
        coordinates[offset + 1] = a.getPoint2d();
        elevations[offset + 1] = 0;
        int[] indices = new int[2];
        for (IBond bond : connected) {
            if (GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            IAtom other = bond.getConnectedAtom(a);
            coordinates[i + offset] = other.getPoint2d();
            elevations[i + offset] = GeometricCumulativeDoubleBondFactory.elevation(bond, a);
            indices[i] = container.getAtomNumber(other);
            ++i;
        }
        if (i == 1) {
            return PermutationParity.IDENTITY;
        }
        return new BasicPermutationParity(indices);
    }

    private static PermutationParity fill3DCoordinates(IAtomContainer container, IAtom a, List<IBond> connected, Point3d[] coordinates, int offset) {
        int i = 0;
        int[] indices = new int[2];
        for (IBond bond : connected) {
            if (GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            IAtom other = bond.getConnectedAtom(a);
            coordinates[i + offset] = other.getPoint3d();
            indices[i] = container.getAtomNumber(other);
            ++i;
        }
        if (i == 1) {
            coordinates[offset + 1] = a.getPoint3d();
            return PermutationParity.IDENTITY;
        }
        return new BasicPermutationParity(indices);
    }

    private static boolean has2DCoordinates(List<IBond> bonds) {
        for (IBond bond : bonds) {
            if (bond.getAtom(0).getPoint2d() != null && bond.getAtom(1).getPoint2d() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean has3DCoordinates(List<IBond> bonds) {
        for (IBond bond : bonds) {
            if (bond.getAtom(0).getPoint3d() != null && bond.getAtom(1).getPoint3d() != null) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="testElevation_Atom_Up,testElevation_Atom_Down")
    static int elevation(IBond bond, IAtom a) {
        return bond.getAtom(0).equals(a) ? GeometricCumulativeDoubleBondFactory.elevation(bond) : GeometricCumulativeDoubleBondFactory.elevation(bond) * -1;
    }

    @TestMethod(value="testElevation_null,testElevation_Up,testElevation_Down")
    static int elevation(IBond bond) {
        IBond.Stereo stereo = bond.getStereo();
        if (stereo == null) {
            return 0;
        }
        switch (stereo) {
            case UP: 
            case DOWN_INVERTED: {
                return 1;
            }
            case DOWN: 
            case UP_INVERTED: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean isOdd(int x) {
        return (x & 1) != 0;
    }

    private static boolean isDoubleBond(IBond bond) {
        return IBond.Order.DOUBLE.equals((Object)bond.getOrder());
    }

    private static class BondMap {
        private Map<IAtom, List<IBond>> bonds;

        BondMap(int n) {
            this.bonds = new HashMap<IAtom, List<IBond>>(n > 3 ? n + n / 3 : n);
        }

        public List<IBond> bonds(IAtom a) {
            List<IBond> bs = this.bonds.get(a);
            return bs != null ? bs : Collections.emptyList();
        }

        public boolean cumulated(IAtom a) {
            return this.bonds(a).size() == 2;
        }

        public void add(IBond bond) {
            this.add(bond.getAtom(0), bond);
            this.add(bond.getAtom(1), bond);
        }

        private void add(IAtom a, IBond b) {
            if (this.bonds(a).isEmpty()) {
                this.bonds.put(a, new ArrayList(2));
            }
            this.bonds.get(a).add(b);
        }

        public Iterable<IAtom> atoms() {
            return this.bonds.keySet();
        }
    }
}

