/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.MDLReaderTest")
public class MDLReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReader.class);
    private BooleanIOSetting forceReadAs3DCoords;
    private static final Pattern TRAILING_SPACE = Pattern.compile("\\s+$");

    public MDLReader() {
        this(new StringReader(""));
    }

    public MDLReader(InputStream in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(InputStream in, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(in));
        this.mode = mode;
    }

    public MDLReader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(Reader in, IChemObjectReader.Mode mode) {
        this.mode = mode;
        this.input = new BufferedReader(in);
        this.initIOSettings();
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        if (IChemFile.class.equals((Object)classObject)) {
            return true;
        }
        if (IChemModel.class.equals((Object)classObject)) {
            return true;
        }
        if (IAtomContainer.class.equals((Object)classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule((IAtomContainer)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m = this.readMolecule(chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer m = this.readMolecule(chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
        if (m != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                logger.debug("line: ", line);
                String str = new String(line);
                if (str.equals("$$$$")) {
                    m = this.readMolecule(chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
                    if (m == null) continue;
                    setOfMolecules.addAtomContainer(m);
                    chemModel.setMoleculeSet(setOfMolecules);
                    chemSequence.addChemModel(chemModel);
                    setOfMolecules = chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    continue;
                }
                if (m == null) continue;
                String fieldName = null;
                if (str.startsWith("> ")) {
                    int index2;
                    str.substring(2);
                    int index = str.indexOf("<");
                    if (index != -1 && (index2 = str.substring(index).indexOf(">")) != -1) {
                        fieldName = str.substring(index + 1, index + index2);
                    }
                    while ((line = this.input.readLine()) != null && line.startsWith(">")) {
                        logger.debug("data header line: ", line);
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String data = line;
                while ((line = this.input.readLine()) != null && line.trim().length() > 0) {
                    if (line.equals("$$$$")) {
                        logger.error("Expecting data line here, but found end of molecule: ", line);
                        break;
                    }
                    logger.debug("data line: ", line);
                    data = data + line;
                    if (line.length() >= 80) continue;
                    data = data + System.getProperty("line.separator");
                }
                if (fieldName == null) continue;
                logger.info("fieldName, data: ", fieldName, ", ", data);
                m.setProperty(fieldName, data);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (Exception exception) {
            String error = "Error while parsing SDF";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error(error);
            throw new CDKException(error, exc);
        }
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private IAtomContainer readMolecule(IAtomContainer molecule) throws CDKException {
        logger.debug("Reading new molecule");
        int linecount = 0;
        int atoms = 0;
        int bonds = 0;
        int atom1 = 0;
        int atom2 = 0;
        int order = 0;
        IBond.Stereo stereo = (IBond.Stereo)((Object)CDKConstants.UNSET);
        int RGroupCounter = 1;
        int Rnumber = 0;
        String[] rGroup = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        String line = "";
        try {
            IsotopeFactory isotopeFactory = IsotopeFactory.getInstance(molecule.getBuilder());
            logger.info("Reading header");
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return null;
            }
            logger.debug("Line " + linecount + ": " + line);
            if (line.startsWith("$$$$")) {
                logger.debug("File is empty, returning empty molecule");
                return molecule;
            }
            if (line.length() > 0) {
                molecule.setProperty("cdk:Title", line);
            }
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            if (line.length() > 0) {
                molecule.setProperty("cdk:Remark", line);
            }
            logger.info("Reading rest of file");
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                if (line.contains("V2000") || line.contains("v2000")) {
                    throw new CDKException("This file must be read with the MDLV2000Reader.");
                }
                if (line.contains("V3000") || line.contains("v3000")) {
                    throw new CDKException("This file must be read with the MDLV3000Reader.");
                }
            }
            atoms = Integer.valueOf(line.substring(0, 3).trim());
            logger.debug("Atomcount: " + atoms);
            bonds = Integer.valueOf(line.substring(3, 6).trim());
            logger.debug("Bondcount: " + bonds);
            logger.info("Reading atom block");
            for (int f = 0; f < atoms; ++f) {
                IAtom atom;
                line = this.input.readLine();
                ++linecount;
                Matcher trailingSpaceMatcher = TRAILING_SPACE.matcher(line);
                if (trailingSpaceMatcher.find()) {
                    this.handleError("Trailing space found", linecount, trailingSpaceMatcher.start(), trailingSpaceMatcher.end());
                    line = trailingSpaceMatcher.replaceAll("");
                }
                x = new Double(line.substring(0, 10).trim());
                y = new Double(line.substring(10, 20).trim());
                z = new Double(line.substring(20, 30).trim());
                totalX += Math.abs(x);
                totalY += Math.abs(y);
                totalZ += Math.abs(z);
                logger.debug("Coordinates: " + x + "; " + y + "; " + z);
                String element = line.substring(31, Math.min(34, line.length())).trim();
                if (line.length() < 34) {
                    this.handleError("Element atom type does not follow V2000 format type should of length three and padded with space if required", linecount, 31, 34);
                }
                logger.debug("Atom type: ", element);
                if (isotopeFactory.isElement(element)) {
                    atom = isotopeFactory.configure(molecule.getBuilder().newInstance(IAtom.class, element));
                } else if ("A".equals(element)) {
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else if ("Q".equals(element)) {
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else if ("*".equals(element)) {
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else if ("LP".equals(element)) {
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else if ("L".equals(element)) {
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else if (element.length() > 0 && element.charAt(0) == 'R') {
                    logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                    rGroup = element.split("^R");
                    if (rGroup.length > 1) {
                        try {
                            RGroupCounter = Rnumber = Integer.parseInt(rGroup[rGroup.length - 1]);
                        }
                        catch (Exception ex) {
                            Rnumber = RGroupCounter++;
                        }
                        element = "R" + Rnumber;
                    }
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                } else {
                    if (this.mode == IChemObjectReader.Mode.STRICT) {
                        throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                    }
                    atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                }
                atom.setPoint3d(new Point3d(x, y, z));
                if (line.length() >= 36) {
                    String massDiffString = line.substring(34, 36).trim();
                    logger.debug("Mass difference: ", massDiffString);
                    if (!(atom instanceof IPseudoAtom)) {
                        try {
                            int massDiff = Integer.parseInt(massDiffString);
                            if (massDiff != 0) {
                                IIsotope major = IsotopeFactory.getInstance(molecule.getBuilder()).getMajorIsotope(element);
                                atom.setAtomicNumber(major.getAtomicNumber() + massDiff);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("Could not parse mass difference field");
                        }
                    } else {
                        logger.error("Cannot set mass difference for a non-element!");
                    }
                } else {
                    this.handleError("Mass difference is missing", linecount, 34, 36);
                }
                if (line.length() >= 39) {
                    String chargeCodeString = line.substring(36, 39).trim();
                    logger.debug("Atom charge code: ", chargeCodeString);
                    int chargeCode = Integer.parseInt(chargeCodeString);
                    if (chargeCode != 0) {
                        if (chargeCode == 1) {
                            atom.setFormalCharge(3);
                        } else if (chargeCode == 2) {
                            atom.setFormalCharge(2);
                        } else if (chargeCode == 3) {
                            atom.setFormalCharge(1);
                        } else if (chargeCode != 4) {
                            if (chargeCode == 5) {
                                atom.setFormalCharge(-1);
                            } else if (chargeCode == 6) {
                                atom.setFormalCharge(-2);
                            } else if (chargeCode == 7) {
                                atom.setFormalCharge(-3);
                            }
                        }
                    }
                } else {
                    this.handleError("Atom charge count is empty", linecount, 35, 39);
                }
                try {
                    String reactionAtomIDString = line.substring(60, 63).trim();
                    logger.debug("Parsing mapping id: ", reactionAtomIDString);
                    try {
                        int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                        if (reactionAtomID != 0) {
                            atom.setProperty("cdk:AtomAtomMapping", reactionAtomID);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Mapping number ", reactionAtomIDString, " is not an integer.");
                        logger.debug(exception);
                    }
                }
                catch (Exception exception) {
                    logger.warn("A few fields are missing. Older MDL MOL file?");
                }
                if (line.length() >= 78) {
                    double shift = Double.parseDouble(line.substring(69, 80).trim());
                    atom.setProperty("first shift", new Double(shift));
                }
                if (line.length() >= 87) {
                    double shift = Double.parseDouble(line.substring(79, 87).trim());
                    atom.setProperty("second shift", new Double(shift));
                }
                molecule.addAtom(atom);
            }
            if (totalX == 0.0 && totalY == 0.0 && totalZ == 0.0) {
                logger.info("All coordinates are 0.0");
                for (IAtom atomToUpdate : molecule.atoms()) {
                    atomToUpdate.setPoint3d(null);
                }
            } else if (totalZ == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                logger.info("Total 3D Z is 0.0, interpreting it as a 2D structure");
                for (IAtom atomToUpdate : molecule.atoms()) {
                    Point3d p3d = atomToUpdate.getPoint3d();
                    atomToUpdate.setPoint2d(new Point2d(p3d.x, p3d.y));
                    atomToUpdate.setPoint3d(null);
                }
            }
            logger.info("Reading bond block");
            for (int f = 0; f < bonds; ++f) {
                line = this.input.readLine();
                ++linecount;
                atom1 = Integer.valueOf(line.substring(0, 3).trim());
                atom2 = Integer.valueOf(line.substring(3, 6).trim());
                order = Integer.valueOf(line.substring(6, 9).trim());
                if (line.length() > 12) {
                    int mdlStereo = Integer.valueOf(line.substring(9, 12).trim());
                    if (mdlStereo == 1) {
                        stereo = IBond.Stereo.UP;
                    } else if (mdlStereo == 6) {
                        stereo = IBond.Stereo.DOWN;
                    } else if (mdlStereo == 0) {
                        stereo = IBond.Stereo.NONE;
                    } else if (mdlStereo == 4) {
                        stereo = IBond.Stereo.UP_OR_DOWN;
                    } else if (mdlStereo == 3) {
                        stereo = IBond.Stereo.E_OR_Z;
                    }
                } else {
                    logger.warn("Missing expected stereo field at line: " + line);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Bond: " + atom1 + " - " + atom2 + "; order " + order);
                }
                IAtom a1 = molecule.getAtom(atom1 - 1);
                IAtom a2 = molecule.getAtom(atom2 - 1);
                IBond newBond = null;
                if (order >= 1 && order <= 3) {
                    IBond.Order cdkOrder = IBond.Order.SINGLE;
                    if (order == 2) {
                        cdkOrder = IBond.Order.DOUBLE;
                    }
                    if (order == 3) {
                        cdkOrder = IBond.Order.TRIPLE;
                    }
                    newBond = stereo != null ? molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder, stereo}) : molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder});
                } else if (order == 4) {
                    newBond = stereo != null ? molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE, stereo}) : molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE});
                    newBond.setFlag(32, true);
                    a1.setFlag(32, true);
                    a2.setFlag(32, true);
                }
                molecule.addBond(newBond);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return molecule;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
    }
}

