/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.silent.AtomType;
import org.openscience.cdk.silent.Element;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Atom
extends AtomType
implements IAtom,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3137373012494608794L;
    protected Point2d point2d = (Point2d)CDKConstants.UNSET;
    protected Point3d point3d = (Point3d)CDKConstants.UNSET;
    protected Point3d fractionalPoint3d = (Point3d)CDKConstants.UNSET;
    protected Integer hydrogenCount = (Integer)CDKConstants.UNSET;
    protected Integer stereoParity = (Integer)CDKConstants.UNSET;
    protected Double charge = (Double)CDKConstants.UNSET;

    public Atom() {
        super((String)null);
    }

    public Atom(String elementSymbol) {
        this(new Element(elementSymbol, PeriodicTable.getAtomicNumber(elementSymbol)));
        this.formalCharge = 0;
    }

    public Atom(String elementSymbol, Point3d point3d) {
        this(elementSymbol);
        this.point3d = point3d;
    }

    public Atom(String elementSymbol, Point2d point2d) {
        this(elementSymbol);
        this.point2d = point2d;
    }

    public Atom(IElement element) {
        super(element);
        if (element instanceof IAtom) {
            this.point2d = ((IAtom)element).getPoint2d() != null ? new Point2d(((IAtom)element).getPoint2d()) : null;
            this.point3d = ((IAtom)element).getPoint3d() != null ? new Point3d(((IAtom)element).getPoint3d()) : null;
            this.fractionalPoint3d = ((IAtom)element).getFractionalPoint3d() != null ? new Point3d(((IAtom)element).getFractionalPoint3d()) : null;
            this.hydrogenCount = ((IAtom)element).getImplicitHydrogenCount();
            this.charge = ((IAtom)element).getCharge();
            this.stereoParity = ((IAtom)element).getStereoParity();
        }
    }

    @Override
    public void setCharge(Double charge) {
        this.charge = charge;
    }

    @Override
    public Double getCharge() {
        return this.charge;
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        return this.hydrogenCount;
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        this.stereoParity = stereoParity;
    }

    @Override
    public Point2d getPoint2d() {
        return this.point2d;
    }

    @Override
    public Point3d getPoint3d() {
        return this.point3d;
    }

    @Override
    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    @Override
    public Integer getStereoParity() {
        return this.stereoParity;
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof IAtom)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Atom atom = (Atom)object;
        return (this.point2d == atom.point2d || this.point2d != null && this.point2d.equals(atom.point2d)) && (this.point3d == atom.point3d || this.point3d != null && this.point3d.equals(atom.point3d)) && this.hydrogenCount == atom.hydrogenCount && this.stereoParity == atom.stereoParity && this.charge == atom.charge;
    }

    @Override
    public boolean isAromatic() {
        return this.getFlag(32);
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    @Override
    public boolean isInRing() {
        return this.getFlag(2);
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer(64);
        stringContent.append("Atom(").append(this.hashCode());
        if (this.getSymbol() != null) {
            stringContent.append(", S:").append(this.getSymbol());
        }
        if (this.getImplicitHydrogenCount() != null) {
            stringContent.append(", H:").append(this.getImplicitHydrogenCount());
        }
        if (this.getStereoParity() != null) {
            stringContent.append(", SP:").append(this.getStereoParity());
        }
        if (this.getPoint2d() != null) {
            stringContent.append(", 2D:[").append(this.getPoint2d()).append(']');
        }
        if (this.getPoint3d() != null) {
            stringContent.append(", 3D:[").append(this.getPoint3d()).append(']');
        }
        if (this.getFractionalPoint3d() != null) {
            stringContent.append(", F3D:[").append(this.getFractionalPoint3d());
        }
        if (this.getCharge() != null) {
            stringContent.append(", C:").append(this.getCharge());
        }
        stringContent.append(", ").append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IAtom clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        if (this.point2d != null) {
            ((Atom)clone).setPoint2d(new Point2d(this.point2d.x, this.point2d.y));
        }
        if (this.point3d != null) {
            ((Atom)clone).setPoint3d(new Point3d(this.point3d.x, this.point3d.y, this.point3d.z));
        }
        if (this.fractionalPoint3d != null) {
            ((Atom)clone).setFractionalPoint3d(new Point3d(this.fractionalPoint3d.x, this.fractionalPoint3d.y, this.fractionalPoint3d.z));
        }
        return (IAtom)clone;
    }
}

