/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.ImplicitHydrogenLigand;
import org.openscience.cdk.geometry.cip.LigancyFourChirality;
import org.openscience.cdk.geometry.cip.Ligand;
import org.openscience.cdk.geometry.cip.TerminalLigand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.geometry.cip.rules.CIPLigandRule;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public class CIPTool {
    public static final int HYDROGEN = -1;
    private static CIPLigandRule cipRule = new CIPLigandRule();

    public static CIP_CHIRALITY getCIPChirality(LigancyFourChirality stereoCenter) {
        ILigand[] ligands = CIPTool.order(stereoCenter.getLigands());
        LigancyFourChirality rsChirality = stereoCenter.project(ligands);
        boolean allAreDifferent = CIPTool.checkIfAllLigandsAreDifferent(ligands);
        if (!allAreDifferent) {
            return CIP_CHIRALITY.NONE;
        }
        if (rsChirality.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE) {
            return CIP_CHIRALITY.R;
        }
        return CIP_CHIRALITY.S;
    }

    public static void label(IAtomContainer container) {
        for (IStereoElement stereoElement : container.stereoElements()) {
            if (stereoElement instanceof ITetrahedralChirality) {
                ITetrahedralChirality tc = (ITetrahedralChirality)stereoElement;
                tc.getChiralAtom().setProperty("cip.label", CIPTool.getCIPChirality(container, tc).toString());
                continue;
            }
            if (!(stereoElement instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)stereoElement;
            dbs.getStereoBond().setProperty("cip.label", CIPTool.getCIPChirality(container, dbs).toString());
        }
    }

    public static CIP_CHIRALITY getCIPChirality(IAtomContainer container, ITetrahedralChirality stereoCenter) {
        LigancyFourChirality tmp = new LigancyFourChirality(container, stereoCenter);
        ITetrahedralChirality.Stereo stereo = stereoCenter.getStereo();
        int parity = CIPTool.permParity(tmp.getLigands());
        if (parity == 0) {
            return CIP_CHIRALITY.NONE;
        }
        if (parity < 0) {
            stereo = stereo.invert();
        }
        if (stereo == ITetrahedralChirality.Stereo.CLOCKWISE) {
            return CIP_CHIRALITY.R;
        }
        if (stereo == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
            return CIP_CHIRALITY.S;
        }
        return CIP_CHIRALITY.NONE;
    }

    public static CIP_CHIRALITY getCIPChirality(IAtomContainer container, IDoubleBondStereochemistry stereoCenter) {
        int p;
        IBond stereoBond = stereoCenter.getStereoBond();
        IBond leftBond = stereoCenter.getBonds()[0];
        IBond rightBond = stereoCenter.getBonds()[1];
        IAtom u = stereoBond.getAtom(0);
        IAtom v = stereoBond.getAtom(1);
        IAtom x = leftBond.getConnectedAtom(u);
        IAtom y = rightBond.getConnectedAtom(v);
        IDoubleBondStereochemistry.Conformation conformation = stereoCenter.getStereo();
        ILigand[] leftLigands = CIPTool.getLigands(u, container, v);
        ILigand[] rightLigands = CIPTool.getLigands(v, container, u);
        if (leftLigands.length > 2 || rightLigands.length > 2) {
            return CIP_CHIRALITY.NONE;
        }
        if (leftLigands[0].getLigandAtom() != x) {
            conformation = conformation.invert();
        }
        if (rightLigands[0].getLigandAtom() != y) {
            conformation = conformation.invert();
        }
        if ((p = CIPTool.permParity(leftLigands) * CIPTool.permParity(rightLigands)) == 0) {
            return CIP_CHIRALITY.NONE;
        }
        if (p < 0) {
            conformation = conformation.invert();
        }
        if (conformation == IDoubleBondStereochemistry.Conformation.TOGETHER) {
            return CIP_CHIRALITY.Z;
        }
        if (conformation == IDoubleBondStereochemistry.Conformation.OPPOSITE) {
            return CIP_CHIRALITY.E;
        }
        return CIP_CHIRALITY.NONE;
    }

    private static ILigand[] getLigands(IAtom atom, IAtomContainer container, IAtom exclude) {
        List<IAtom> neighbors = container.getConnectedAtomsList(atom);
        ILigand[] ligands = new ILigand[neighbors.size() - 1];
        int i = 0;
        for (IAtom neighbor : neighbors) {
            if (neighbor == exclude) continue;
            ligands[i++] = new Ligand(container, new VisitedAtoms(), atom, neighbor);
        }
        return ligands;
    }

    public static boolean checkIfAllLigandsAreDifferent(ILigand[] ligands) {
        for (int i = 0; i < ligands.length - 1; ++i) {
            if (cipRule.compare(ligands[i], ligands[i + 1]) != 0) continue;
            return false;
        }
        return true;
    }

    public static ILigand[] order(ILigand[] ligands) {
        ILigand[] newLigands = new ILigand[ligands.length];
        System.arraycopy(ligands, 0, newLigands, 0, ligands.length);
        Arrays.sort(newLigands, cipRule);
        return newLigands;
    }

    private static int permParity(ILigand[] ligands) {
        int swaps = 0;
        int hi = ligands.length;
        for (int j = 1; j < hi; ++j) {
            ILigand ligand = ligands[j];
            int i = j - 1;
            int cmp = 0;
            while (i >= 0 && (cmp = cipRule.compare(ligand, ligands[i])) > 0) {
                ligands[i + 1] = ligands[i--];
                ++swaps;
            }
            if (cmp == 0) {
                return 0;
            }
            ligands[i + 1] = ligand;
        }
        return swaps & true ? -1 : 1;
    }

    public static LigancyFourChirality defineLigancyFourChirality(IAtomContainer container, int chiralAtom, int ligand1, int ligand2, int ligand3, int ligand4, ITetrahedralChirality.Stereo stereo) {
        int[] atomIndices = new int[]{ligand1, ligand2, ligand3, ligand4};
        VisitedAtoms visitedAtoms = new VisitedAtoms();
        ILigand[] ligands = new ILigand[4];
        for (int i = 0; i < 4; ++i) {
            ligands[i] = CIPTool.defineLigand(container, visitedAtoms, chiralAtom, atomIndices[i]);
        }
        return new LigancyFourChirality(container.getAtom(chiralAtom), ligands, stereo);
    }

    public static ILigand defineLigand(IAtomContainer container, VisitedAtoms visitedAtoms, int chiralAtom, int ligandAtom) {
        if (ligandAtom == -1) {
            return new ImplicitHydrogenLigand(container, visitedAtoms, container.getAtom(chiralAtom));
        }
        return new Ligand(container, visitedAtoms, container.getAtom(chiralAtom), container.getAtom(ligandAtom));
    }

    public static ILigand[] getLigandLigands(ILigand ligand) {
        if (ligand instanceof TerminalLigand) {
            return new ILigand[0];
        }
        IAtomContainer container = ligand.getAtomContainer();
        IAtom ligandAtom = ligand.getLigandAtom();
        IAtom centralAtom = ligand.getCentralAtom();
        VisitedAtoms visitedAtoms = ligand.getVisitedAtoms();
        List<IBond> bonds = container.getConnectedBondsList(ligandAtom);
        ArrayList<Ligand> ligands = new ArrayList<Ligand>();
        for (IBond bond : bonds) {
            int duplication;
            if (bond.contains(centralAtom)) {
                if (IBond.Order.SINGLE == bond.getOrder() || (duplication = CIPTool.getDuplication(bond.getOrder()) - 1) <= 0) continue;
                for (int i = 1; i <= duplication; ++i) {
                    ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, centralAtom));
                }
                continue;
            }
            duplication = CIPTool.getDuplication(bond.getOrder());
            IAtom connectedAtom = bond.getConnectedAtom(ligandAtom);
            if (visitedAtoms.isVisited(connectedAtom)) {
                ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, connectedAtom));
            } else {
                ligands.add(new Ligand(container, visitedAtoms, ligandAtom, connectedAtom));
            }
            for (int i = 2; i <= duplication; ++i) {
                ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, connectedAtom));
            }
        }
        return ligands.toArray(new ILigand[0]);
    }

    private static int getDuplication(IBond.Order order) {
        return order == null ? 0 : order.numeric();
    }

    public static enum CIP_CHIRALITY {
        R,
        S,
        E,
        Z,
        NONE;

    }
}

