/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.ringsearch.CyclicVertexSearch;
import org.openscience.cdk.ringsearch.JumboCyclicVertexSearch;
import org.openscience.cdk.ringsearch.RegularCyclicVertexSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.ringsearch.RingSearchTest")
public final class RingSearch {
    private final CyclicVertexSearch searcher;
    private final IAtomContainer container;

    @TestMethod(value="testNull")
    public RingSearch(IAtomContainer container) {
        this(container, RingSearch.toAdjList(container));
    }

    @TestMethod(value="testNullContainer,testNullGraph")
    public RingSearch(IAtomContainer container, int[][] graph) {
        this(container, RingSearch.makeSearcher(graph));
    }

    @TestMethod(value="testNullCyclicSearch")
    public RingSearch(IAtomContainer container, CyclicVertexSearch searcher) {
        if (container == null) {
            throw new NullPointerException("container must not be null");
        }
        if (searcher == null) {
            throw new NullPointerException("searcher was null");
        }
        this.searcher = searcher;
        this.container = container;
    }

    private static CyclicVertexSearch makeSearcher(int[][] graph) {
        if (graph == null) {
            throw new NullPointerException("graph[][] must not be null");
        }
        if (graph.length <= 64) {
            return new RegularCyclicVertexSearch(graph);
        }
        return new JumboCyclicVertexSearch(graph);
    }

    @TestMethod(value="testCyclic_Int")
    public boolean cyclic(int i) {
        return this.searcher.cyclic(i);
    }

    @TestMethod(value="testCyclic_Atom")
    public boolean cyclic(IAtom atom) {
        int i = this.container.getAtomNumber(atom);
        if (i < 0) {
            throw new NoSuchElementException("no such atom");
        }
        return this.cyclic(i);
    }

    @TestMethod(value="testCyclic")
    public int[] cyclic() {
        return this.searcher.cyclic();
    }

    @TestMethod(value="testIsolated")
    public int[][] isolated() {
        return this.searcher.isolated();
    }

    @TestMethod(value="testFused")
    public int[][] fused() {
        return this.searcher.fused();
    }

    @TestMethod(value="testRingFragments")
    public IAtomContainer ringFragments() {
        int[] color = this.vertexColor();
        int[] vertices = this.cyclic();
        int n = vertices.length;
        IAtom[] atoms = new IAtom[n];
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int i = 0; i < vertices.length; ++i) {
            atoms[i] = this.container.getAtom(vertices[i]);
        }
        for (IBond bond : this.container.bonds()) {
            int v;
            IAtom either = bond.getAtom(0);
            IAtom other = bond.getAtom(1);
            int u = this.container.getAtomNumber(either);
            if (!RingSearch.match(color[u], color[v = this.container.getAtomNumber(other)])) continue;
            bonds.add(bond);
        }
        IChemObjectBuilder builder = this.container.getBuilder();
        IAtomContainer fragment = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms);
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }

    @TestMethod(value="testMatch")
    static boolean match(int eitherColor, int otherColor) {
        return eitherColor != -1 && otherColor != -1 && (eitherColor == otherColor || eitherColor == 0 || otherColor == 0);
    }

    private int[] vertexColor() {
        int i;
        int[] color = new int[this.container.getAtomCount()];
        int[][] isolated = this.searcher.isolated();
        int[][] fused = this.searcher.fused();
        Arrays.fill(color, -1);
        for (i = 0; i < isolated.length; ++i) {
            for (int v : isolated[i]) {
                color[v] = color[v] < 0 ? i + 1 : 0;
            }
        }
        for (i = 0; i < fused.length; ++i) {
            for (int v : fused[i]) {
                int n = color[v] < 0 ? isolated.length + i + 1 : 0;
                color[v] = n;
            }
        }
        return color;
    }

    @TestMethod(value="testIsolatedRingFragments")
    public List<IAtomContainer> isolatedRingFragments() {
        return this.toFragments(this.isolated());
    }

    @TestMethod(value="testFusedRingFragments")
    public List<IAtomContainer> fusedRingFragments() {
        return this.toFragments(this.fused());
    }

    private List<IAtomContainer> toFragments(int[][] verticesList) {
        ArrayList<IAtomContainer> fragments = new ArrayList<IAtomContainer>();
        for (int[] vertices : verticesList) {
            fragments.add(this.toFragment(vertices));
        }
        return fragments;
    }

    private IAtomContainer toFragment(int[] vertices) {
        int n = vertices.length;
        HashSet<IAtom> atoms = new HashSet<IAtom>(n > 3 ? n + 1 + n / 3 : n);
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int v : vertices) {
            atoms.add(this.container.getAtom(v));
        }
        for (IBond bond : this.container.bonds()) {
            IAtom either = bond.getAtom(0);
            IAtom other = bond.getAtom(1);
            if (!atoms.contains(either) || !atoms.contains(other)) continue;
            bonds.add(bond);
        }
        IAtomContainer fragment = this.container.getBuilder().newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms.toArray(new IAtom[n]));
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }

    private static int[][] toAdjList(IAtomContainer container) {
        if (container == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][16];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            int v = container.getAtomNumber(bond.getAtom(0));
            int w = container.getAtomNumber(bond.getAtom(1));
            if (v < 0 || w < 0) {
                throw new NoSuchElementException("bond at index " + container.getBondNumber(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] != graph[w].length) continue;
            graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }
}

