/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.graph.compose.PolyadicPrefixMappingImpl;
import com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Polyadic
extends CompositionBase {
    protected List<Graph> m_subGraphs = new ArrayList<Graph>();
    protected Graph m_baseGraph = null;
    private PrefixMapping pm;

    public Polyadic() {
    }

    public Polyadic(Graph[] graphs) {
        for (int i = 0; i < graphs.length; ++i) {
            this.m_subGraphs.add(graphs[i]);
        }
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        if (this.pm == null) {
            this.pm = new PolyadicPrefixMappingImpl(this);
        }
        return this.pm;
    }

    public Polyadic(Iterator<Graph> graphs) {
        while (graphs.hasNext()) {
            this.m_subGraphs.add(graphs.next());
        }
        if (graphs instanceof ClosableIterator) {
            ((ClosableIterator)graphs).close();
        }
    }

    @Override
    public void close() {
        Iterator<Graph> i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            i.next().close();
        }
        super.close();
    }

    @Override
    public boolean dependsOn(Graph graph) {
        return graph == this || this.m_subGraphs.contains(graph);
    }

    public void addGraph(Graph graph) {
        this.m_subGraphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        this.m_subGraphs.remove(graph);
        if (this.m_baseGraph == graph) {
            this.m_baseGraph = null;
        }
    }

    public Graph getBaseGraph() {
        if (this.m_baseGraph == null) {
            return this.m_subGraphs.size() == 0 ? null : this.m_subGraphs.get(0);
        }
        return this.m_baseGraph;
    }

    public Graph getRequiredBaseGraph() {
        Graph base = this.getBaseGraph();
        if (base == null) {
            throw new JenaException("This polyadic graph should have a base graph, but none is defined");
        }
        return base;
    }

    public void setBaseGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            throw new IllegalArgumentException("The updateable graph must be one of the graphs from the composition");
        }
        this.m_baseGraph = graph;
        this.bulkHandler = null;
    }

    public List<Graph> getSubGraphs() {
        ArrayList<Graph> sg = new ArrayList<Graph>(this.m_subGraphs);
        if (this.getBaseGraph() != null) {
            sg.remove(this.getBaseGraph());
        }
        return sg;
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new WrappedBulkUpdateHandler(this, this.getRequiredBaseGraph().getBulkUpdateHandler());
        }
        return this.bulkHandler;
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.getBaseGraph() == null ? super.getTransactionHandler() : this.getBaseGraph().getTransactionHandler();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.getBaseGraph() == null ? super.getCapabilities() : this.getBaseGraph().getCapabilities();
    }
}

