/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.graph.invariant.InChINumbersToolsTest")
public class InChINumbersTools {
    @TestMethod(value="testSimpleNumbering,testHydrogens,testGlycine")
    public static long[] getNumbers(IAtomContainer atomContainer) throws CDKException {
        long[] atomNumbers = new long[atomContainer.getAtomCount()];
        InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
        InChIGenerator gen = factory.getInChIGenerator(atomContainer);
        if (gen.getReturnStatus() != INCHI_RET.OKAY) {
            throw new CDKException("Could not generate InChI.");
        }
        String aux = gen.getAuxInfo();
        aux = aux.substring(aux.indexOf("/N:") + 3);
        String numberStringAux = aux.substring(0, aux.indexOf("/"));
        String[] numberStrings = numberStringAux.split("\\,");
        int i = 0;
        for (String numberString : numberStrings) {
            atomNumbers[Integer.valueOf((String)numberString).intValue() - 1] = ++i;
        }
        return atomNumbers;
    }
}

