/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.HashSet;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.SetCharge;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.selection.MultiSelection;

public class ChangeFormalChargeModule
extends ControllerModuleAdapter {
    private int change = 0;

    public ChangeFormalChargeModule(IChemModelRelay chemModelRelay, int change) {
        super(chemModelRelay);
        this.change = change;
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IAtomContainer selectedAC = this.getSelectedAtomContainer(worldCoord);
        if (selectedAC == null) {
            return;
        }
        HashSet<IAtom> newSelection = new HashSet<IAtom>();
        for (IAtom atom : selectedAC.atoms()) {
            newSelection.add(atom);
            int newCharge = this.change;
            if (atom.getFormalCharge() != null) {
                newCharge += atom.getFormalCharge().intValue();
            }
            this.chemModelRelay.execute(SetCharge.setCharge(atom, newCharge));
        }
        this.setSelection(new MultiSelection(newSelection));
    }

    @Override
    public String getDrawModeString() {
        if (this.change < 0) {
            return "Decrease Charge";
        }
        return "Increase Charge";
    }
}

