/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.helper;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.smsd.helper.BondEnergyTest")
public class BondEnergy {
    private String symbol1 = "";
    private String symbol2 = "";
    private IBond.Order bondOrder = null;
    private int energy = -1;

    @TestMethod(value="BondEnergyTest")
    public BondEnergy(String symbol1, String symbol2, IBond.Order order, int energy) {
        this.symbol1 = symbol1;
        this.symbol2 = symbol2;
        this.bondOrder = order;
        this.energy = energy;
    }

    @TestMethod(value="testGetSymbolFirstAtom")
    public String getSymbolFirstAtom() {
        return this.symbol1;
    }

    @TestMethod(value="testGetSymbolSecondAtom")
    public String getSymbolSecondAtom() {
        return this.symbol2;
    }

    @TestMethod(value="testGetBondOrder")
    public IBond.Order getBondOrder() {
        return this.bondOrder;
    }

    @TestMethod(value="testGetEnergy")
    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(IBond bond) {
        IAtom atom1 = bond.getAtom(0);
        IAtom atom2 = bond.getAtom(1);
        return (atom1.getSymbol().equalsIgnoreCase(this.symbol1) && atom2.getSymbol().equalsIgnoreCase(this.symbol2) || atom1.getSymbol().equalsIgnoreCase(this.symbol2) && atom2.getSymbol().equalsIgnoreCase(this.symbol1)) && bond.getOrder().compareTo(this.bondOrder) == 0;
    }
}

