/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.Renderer2D;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ViewMolecule2D
extends JPanel {
    IAtomContainer molecule;
    JFrame frame;
    Renderer2DModel r2dm;
    Renderer2D renderer;
    int width = 300;
    int height = 300;
    double scale = 0.9;

    public ViewMolecule2D(IAtomContainer molecule) throws CDKException {
        this.molecule = molecule;
        if (!ConnectivityChecker.isConnected((IAtomContainer)molecule)) {
            throw new CDKException("Molecule must be connected");
        }
        this.frame = new JFrame("2D Structure Viewer");
        this.frame.addWindowListener(new ApplicationCloser());
        this.frame.setSize(300, 300);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.renderer.paintMolecule(this.molecule, (Graphics2D)g, false, true);
    }

    public void draw() {
        this.molecule = AtomContainerManipulator.removeHydrogens((IAtomContainer)this.molecule);
        try {
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)this.molecule);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.r2dm = new Renderer2DModel();
        this.renderer = new Renderer2D(this.r2dm);
        Dimension screenSize = new Dimension(this.width, this.height);
        this.setPreferredSize(screenSize);
        this.r2dm.setBackgroundDimension(screenSize);
        this.setBackground(this.r2dm.getBackColor());
        try {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule((IMolecule)this.molecule);
            sdg.generateCoordinates();
            this.molecule = sdg.getMolecule();
            this.r2dm.setDrawNumbers(false);
            this.r2dm.setUseAntiAliasing(true);
            this.r2dm.setColorAtomsByType(true);
            this.r2dm.setShowImplicitHydrogens(true);
            this.r2dm.setShowAromaticity(true);
            this.r2dm.setShowReactionBoxes(false);
            this.r2dm.setKekuleStructure(false);
            GeometryTools.translateAllPositive((IAtomContainer)this.molecule, (HashMap)this.r2dm.getRenderingCoordinates());
            GeometryTools.scaleMolecule((IAtomContainer)this.molecule, (Dimension)this.getPreferredSize(), (double)this.scale, (HashMap)this.r2dm.getRenderingCoordinates());
            GeometryTools.center((IAtomContainer)this.molecule, (Dimension)this.getPreferredSize(), (HashMap)this.r2dm.getRenderingCoordinates());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.frame.getContentPane().add(this);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        public void windowClosing(WindowEvent e) {
            ViewMolecule2D.this.frame.dispose();
        }
    }
}

