/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    Viewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    int[] altArgbsCpk;
    boolean isDefaultColorRasmol;
    short colixSelection = (short)3;
    short colixRubberband = (short)22;
    int argbBackground;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        int i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.altArgbsCpk[i] = JmolConstants.altArgbsCpk[i];
        }
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void setDefaultColors(String colorScheme) {
        if (colorScheme.equals("jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
            this.viewer.setColorBackground("black");
        } else if (colorScheme.equals("rasmol")) {
            this.isDefaultColorRasmol = true;
            this.copyArgbsCpk();
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int i = this.argbsCpk.length;
            while (--i >= 0) {
                this.argbsCpk[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argb >> 24;
                this.argbsCpk[atomNo] = argb |= 0xFF000000;
            }
            this.viewer.setColorBackground("black");
        } else {
            Logger.error("unrecognized color scheme");
            return;
        }
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
        i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + i), this.altArgbsCpk[i]);
        }
    }

    void copyArgbsCpk() {
        this.argbsCpk = new int[JmolConstants.argbsCpk.length];
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.argbsCpk[i] = JmolConstants.argbsCpk[i];
        }
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.altArgbsCpk[i] = JmolConstants.altArgbsCpk[i];
        }
    }

    void setSelectionArgb(int argb) {
        this.colixSelection = argb == 0 ? (short)0 : Graphics3D.getColix(argb);
    }

    short getColixSelection() {
        return this.colixSelection;
    }

    void setRubberbandArgb(int argb) {
        this.colixRubberband = argb == 0 ? (short)0 : Graphics3D.getColix(argb);
    }

    void setBackgroundArgb(int argb) {
        this.argbBackground = argb;
        this.g3d.setBackgroundArgb(argb);
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb(argb) & 0xFF) < 128 ? 8 : 4);
    }

    void setColorBackground(String colorName) {
        if (colorName != null && colorName.length() > 0) {
            this.setBackgroundArgb(Graphics3D.getArgbFromString(colorName));
        }
    }

    public short getColixBackgroundContrast() {
        return this.colixBackgroundContrast;
    }

    short getColixAtom(Atom atom) {
        return this.getColixAtomPalette(atom, "cpk");
    }

    short getColixCpkAtomNumber(short id) {
        if (id < 256) {
            return this.g3d.getChangableColix(id, this.argbsCpk[id]);
        }
        id = (short)JmolConstants.altElementIndexFromNumber(id);
        return this.g3d.getChangableColix((short)(JmolConstants.elementNumberMax + id), this.altArgbsCpk[id]);
    }

    short getColixAtomPalette(Atom atom, String palette) {
        int argb = 0;
        if ("cpk" == palette) {
            short id = atom.getAtomicAndIsotopeNumber();
            return this.getColixCpkAtomNumber(id);
        }
        if ("partialcharge" == palette) {
            int index = this.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
            return this.g3d.getChangableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + index), JmolConstants.argbsRwbScale[index]);
        }
        if ("formalcharge" == palette) {
            int index = atom.getFormalCharge() - -4;
            return this.g3d.getChangableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + index), JmolConstants.argbsFormalCharge[index]);
        }
        if ("temperature" == palette || "fixedtemperature" == palette) {
            float hi;
            float lo;
            if ("temperature" == palette) {
                Frame frame = this.viewer.getFrame();
                lo = frame.getBfactor100Lo();
                hi = frame.getBfactor100Hi();
            } else {
                lo = 0.0f;
                hi = 10000.0f;
            }
            int index = this.quantize(atom.getBfactor100(), lo, hi, JmolConstants.argbsRwbScale.length);
            index = JmolConstants.argbsRwbScale.length - 1 - index;
            argb = JmolConstants.argbsRwbScale[index];
        } else if ("surfacedistance" == palette) {
            float hi = this.viewer.getFrame().getSurfaceDistanceMax();
            int index = this.quantize(atom.getSurfaceDistance(), 0.0f, hi, JmolConstants.argbsRwbScale.length);
            argb = JmolConstants.argbsRwbScale[index];
        } else if ("structure" == palette) {
            argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
        } else if ("amino" == palette) {
            short index = atom.getGroupID();
            if (index < 0 || index >= 23) {
                index = 0;
            }
            argb = JmolConstants.argbsAmino[index];
        } else if ("shapely" == palette) {
            short index = atom.getGroupID();
            if (index < 0 || index >= 36) {
                index = 0;
            }
            argb = JmolConstants.argbsShapely[index];
        } else if ("chain" == palette) {
            int chain = atom.getChainID() & 0x1F;
            if (chain < 0) {
                chain = 0;
            }
            if (chain >= JmolConstants.argbsChainAtom.length) {
                chain %= JmolConstants.argbsChainAtom.length;
            }
            argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
        } else if ("group" == palette) {
            int index = this.quantize(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, JmolConstants.argbsRoygbScale.length);
            index = JmolConstants.argbsRoygbScale.length - 1 - index;
            argb = JmolConstants.argbsRoygbScale[index];
        } else if ("monomer" == palette) {
            int index = this.quantize(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, JmolConstants.argbsRoygbScale.length);
            index = JmolConstants.argbsRoygbScale.length - 1 - index;
            argb = JmolConstants.argbsRoygbScale[index];
        } else if ("molecule" == palette) {
            Frame frame = this.viewer.getFrame();
            int index = this.quantize(frame.getMoleculeIndex(atom.atomIndex), 0.0f, frame.getMoleculeCountInModel(atom.modelIndex) - 1, JmolConstants.argbsRoygbScale.length);
            argb = JmolConstants.argbsRoygbScale[index];
        } else if ("altloc" == palette) {
            Frame frame = this.viewer.getFrame();
            int index = this.quantize(frame.getAltLocIndexInModel(atom.modelIndex, (char)atom.alternateLocationID), 0.0f, frame.getAltLocCountInModel(atom.modelIndex), JmolConstants.argbsRoygbScale.length);
            argb = JmolConstants.argbsRoygbScale[index];
        } else if ("insertion" == palette) {
            Frame frame = this.viewer.getFrame();
            int index = this.quantize(frame.getInsertionCodeIndexInModel(atom.modelIndex, atom.getInsertionCode()), 0.0f, frame.getInsertionCountInModel(atom.modelIndex), JmolConstants.argbsRoygbScale.length);
            argb = JmolConstants.argbsRoygbScale[index];
        } else {
            Logger.error("ColorManager.getColixAtomPalette: unrecognized color palette:" + palette);
            return 22;
        }
        if (argb == 0) {
            return 22;
        }
        return Graphics3D.getColix(argb);
    }

    int quantize(float val, float lo, float hi, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 1.0E-4f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    short getColixFromPalette(float val, float lo, float hi, String palette) {
        if (palette.equals("rwb")) {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRwbScale.length);
            return Graphics3D.getColix(JmolConstants.argbsRwbScale[index]);
        }
        if (palette.equals("roygb")) {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRoygbScale.length);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[index]);
        }
        int ihalf = JmolConstants.argbsRoygbScale.length / 2;
        if (palette.equals("low")) {
            int index = this.quantize(val, lo, hi, ihalf);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[index]);
        }
        if (palette.equals("high")) {
            int index = this.quantize(val, lo, hi, ihalf);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[ihalf + index]);
        }
        return 12;
    }

    short getColixHbondType(short order) {
        int argbIndex = (order & 0x3C0) >> 6;
        return Graphics3D.getColix(JmolConstants.argbsHbondType[argbIndex]);
    }

    void flushCachedColors() {
    }

    private void flushCaches() {
        this.g3d.flushShadesAndImageCaches();
        this.viewer.refresh(0, "ColorManager:flushCaches()");
    }

    void setSpecular(boolean specular) {
        this.g3d.setSpecular(specular);
        this.flushCaches();
    }

    boolean getSpecular() {
        return this.g3d.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.g3d.setSpecularPower(specularPower);
        this.flushCaches();
    }

    void setAmbientPercent(int ambientPercent) {
        this.g3d.setAmbientPercent(ambientPercent);
        this.flushCaches();
    }

    void setDiffusePercent(int diffusePercent) {
        this.g3d.setDiffusePercent(diffusePercent);
        this.flushCaches();
    }

    void setSpecularPercent(int specularPercent) {
        this.g3d.setSpecularPercent(specularPercent);
        this.flushCaches();
    }

    void setLightsourceZ(float dist) {
        this.g3d.setLightsourceZ(dist);
        this.flushCaches();
    }

    void setElementArgb(int id, int argb) {
        if (argb == 16430) {
            if (this.argbsCpk == JmolConstants.argbsCpk) {
                return;
            }
            argb = id < 256 ? JmolConstants.argbsCpk[id] : JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(id)];
        } else if (argb == 16392) {
            if (id < 256) {
                argb = JmolConstants.argbsCpk[id];
                int i = JmolConstants.argbsCpkRasmol.length;
                while (--i >= 0) {
                    int argbRasmol = JmolConstants.argbsCpkRasmol[i];
                    int atomNo = argbRasmol >> 24;
                    if (atomNo != id) continue;
                    argb = argbRasmol | 0xFF000000;
                    break;
                }
            } else {
                argb = JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(id)];
            }
        } else {
            argb |= 0xFF000000;
        }
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.copyArgbsCpk();
        }
        if (id < 256) {
            this.argbsCpk[id] = argb;
            this.g3d.changeColixArgb((short)id, argb);
            return;
        }
        id = JmolConstants.altElementIndexFromNumber(id);
        this.altArgbsCpk[JmolConstants.altElementIndexFromNumber((int)id)] = argb;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + id), argb);
    }
}

