% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bin.R
\name{read_bin}
\alias{read_bin}
\title{Read binarized images}
\usage{
read_bin(path)
}
\arguments{
\item{path}{Character vector of length one. Path to a binarized image.}
}
\value{
An object from class \linkS4class{SpatRaster}.
}
\description{
Wrapper functions for \code{\link[terra:rast]{terra::rast()}}.
}
\examples{
\dontrun{
z <- zenith_image(1000, lens())
m <- !is.na(z)
my_file <- file.path(tempdir(), "mask.tif")
write_bin(m, my_file)
m_from_disk <- read_bin(my_file)
plot(m - m_from_disk)
}
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
