% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rings_segmentation.R
\name{rings_segmentation}
\alias{rings_segmentation}
\title{Rings segmentation}
\usage{
rings_segmentation(z, angle_width, return_angle = FALSE)
}
\arguments{
\item{z}{\linkS4class{RasterLayer} built with
\code{\link{zenith_image}}.}

\item{angle_width}{Numeric vector of length one. Angle in degrees able to
divide the angle range into a whole number of segments.}

\item{return_angle}{Logical vector of length one. If it is \code{FALSE}, all
the pixels that belong to a segment are labeled with an ID number.
Otherwise, the angle mean of the segment is assigned to the pixels.}
}
\value{
An object from the class \linkS4class{RasterLayer} with segments
  shaped like concentric rings.
}
\description{
Segmenting an hemispherical view by slicing the zenith angle from \code{0} to
\code{90º} in equals intervals.
}
\examples{
z <- zenith_image(1490, lens())
rings <- rings_segmentation(z, 15)
plot(rings == 1)
}
\seealso{
Other Segmentation functions: 
\code{\link{mask_hs}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation functions}
