% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_thr.R
\name{apply_thr}
\alias{apply_thr}
\title{Apply threshold}
\usage{
apply_thr(r, thr)
}
\arguments{
\item{r}{\linkS4class{RasterLayer}}

\item{thr}{Numeric vector of length one or \linkS4class{RasterLayer}.
Threshold.}
}
\value{
An object of class \linkS4class{RasterLayer} with values \code{0} and
  \code{1}.
}
\description{
Global or local thresholding of images.
}
\details{
It is a wrapper function around the operator \code{>} from the ‘raster’
package. If a single threshold value is provided as \code{thr} argument, it
is applied to every pixel of the raster object \code{r}. If instead a
\linkS4class{RasterLayer} is provided, then a particular threshold is applied
to each particular pixel.
}
\examples{
r <- read_caim()
apply_thr(r$Blue, 120)
\dontrun{
# This function is useful in combination with the ‘autothresholdr’
# package. For example:
require(autothresholdr)
thr <- auto_thresh(r$Blue[], "IsoData")[1]
bin <- apply_thr(r$Blue, thr)
plot(bin)
}
}
\seealso{
Other Tools functions: 
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
