% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_hexbin.R
\name{ly_hexbin}
\alias{ly_hexbin}
\title{Add a "hexbin" layer to a Bokeh figure}
\usage{
ly_hexbin(
  fig,
  x,
  y = NULL,
  data = figure_data(fig),
  xbins = 30,
  shape = 1,
  xbnds = NULL,
  ybnds = NULL,
  style = "colorscale",
  trans = NULL,
  inv = NULL,
  lname = NULL,
  palette = "RdYlGn11",
  line = FALSE,
  alpha = 1,
  hover = TRUE
)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{values or field name of center x coordinates to be binned}

\item{y}{values or field name of center y coordinates to be binned}

\item{data}{an optional data frame, providing the source for x and y}

\item{xbins, shape, xbnds, ybnds}{parameters passed to \code{\link[hexbin]{hexbin}}}

\item{style}{type of plotting for hexbins (see \code{\link[hexbin]{grid.hexagons}}) - "colorramp" and "lattice" are currently supported}

\item{trans, inv}{transformation and inverse transformation function for the bin counts}

\item{lname}{layer name}

\item{palette}{name of color palette to use for color ramp (see \href{https://bokeh.pydata.org/en/latest/docs/reference/palettes.html}{here} for acceptable values)}

\item{line}{logical - should hexagons have an outline?}

\item{alpha}{the alpha transparency of the hexagons between 0 (transparent) and 1 (opaque)}

\item{hover}{logical - should a hover tool be added to show the count in each hexagon?}
}
\description{
Add a "hexbin" layer to a Bokeh figure
}
\examples{
\donttest{
figure() \%>\% ly_hexbin(rnorm(10000), rnorm(10000))
}
}
