% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_biom.r, R/write_xlsx.r
\name{write_biom}
\alias{write_biom}
\alias{write_metadata}
\alias{write_counts}
\alias{write_taxonomy}
\alias{write_fasta}
\alias{write_tree}
\alias{write_xlsx}
\title{Save an rbiom object to a file.}
\usage{
write_biom(biom, file, format = "json")

write_metadata(biom, file, quote = FALSE, sep = "\\t", ...)

write_counts(biom, file, quote = FALSE, sep = "\\t", ...)

write_taxonomy(biom, file, quote = FALSE, sep = "\\t", ...)

write_fasta(biom, file = NULL)

write_tree(biom, file = NULL)

write_xlsx(biom, file, depth = 0.1, n = NULL, seed = 0, unc = "singly")
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{file}{Path to the output file. File names ending in \code{.gz} or
\code{.bz2} will be compressed accordingly.
Setting \code{file=NULL} for \code{write_fasta()}, \code{write_tree()}, and
\code{write_biom(format='json')}, and returns a string of the output which
would have been written. For \code{write_biom(format='tab')}, \code{file=NULL}
returns the tibble that would have been written.}

\item{format}{Options are \code{"tab"}, \code{"json"}, and \code{"hdf5"},
corresponding to classic tabular format, BIOM format version 1.0 and
biom version 2.1, respectively. NOTE: to write HDF5 formatted BIOM
files, the BioConductor R package \code{rhdf5} must be installed.
Default: \code{"json"}}

\item{quote, sep, ...}{Parameters passed on to \code{\link[=write.table]{write.table()}}.
Default: \verb{quote=FALSE, sep="\\t"}}

\item{depth, n}{Passed on to \code{\link[=rarefy_cols]{rarefy_cols()}}. For \code{write_xlsx()} only,
\code{depth=0} disables rarefaction. Default: \verb{depth=0.1, n=NULL}}

\item{seed}{Random seed to use in rarefying. See \code{\link[=rarefy_cols]{rarefy_cols()}} function
for details. Must be a non-negative integer. Default: \code{0}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}
}
\value{
The normalized filepath that was written to (invisibly), unless
\code{file=NULL} (see \code{file} argument above).
}
\description{
Automatically creates directories and adds compression based on file name.
\describe{
\item{\code{write_biom()} - }{ According to \href{http://biom-format.org/documentation/}{BIOM format} specification. }
\item{\code{write_xlsx()} - }{ Raw data and summary tables in Excel file format. See details. }
\item{\code{write_fasta()} - }{ Sequences only in fasta format. \code{biom} may also be a named character vector. }
\item{\code{write_tree()} - }{ Phylogenetic tree only in newick format. \code{biom} may also be a phylo object. }
\item{\code{write_counts()}, \code{write_metadata()}, \code{write_taxonomy()} - }{ Tab-separated values. }
}
}
\details{
For \code{write_xlsx()}, \code{attributes(biom)} are saved as additional worksheets if
the attribute is a data frame, matrix, or dist -class object. An attribute
named 'Reads Per Step' is treated specially and merged with the usual 'Reads
Per Sample' tab.
}
\examples{
    library(rbiom)
    
    write_tree(hmp50) \%>\% substr(1, 50)
    
    if (FALSE) {
    
      hmp10        <- hmp50$clone()
      hmp10$counts <- hmp10$counts[,1:10] \%>\% rarefy_cols()
      
      attr(hmp10, "Weighted UniFrac")   <- bdiv_distmat(hmp10, 'unifrac')
      attr(hmp10, "Unweighted Jaccard") <- bdiv_distmat(hmp10, 'jaccard', weighted=FALSE)
      
      outfile <- write_xlsx(hmp10, tempfile(fileext = ".xlsx"))
    }

}
