% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.r
\name{with}
\alias{with}
\alias{with.rbiom}
\alias{within.rbiom}
\title{Evaluate expressions on metadata.}
\usage{
\method{with}{rbiom}(data, expr, ...)

\method{within}{rbiom}(data, expr, clone = TRUE, ...)
}
\arguments{
\item{data}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{expr}{Passed on to \code{\link[base:with]{base::with()}} or \code{\link[base:with]{base::within()}}.}

\item{...}{Not used.}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}
}
\value{
See description.
}
\description{
\code{with()} will return the result of your expression. \code{within()} will return
an rbiom object.
}
\examples{
    library(rbiom) 
    
    with(hmp50, table(`Body Site`, Sex))
    
    biom <- within(hmp50, {
      age_bin = cut(Age, 5)
      bmi_bin = cut(BMI, 5)
    })
    biom$metadata

}
\seealso{
Other transformations: 
\code{\link{modify_metadata}},
\code{\link{rarefy}()},
\code{\link{rarefy_cols}()},
\code{\link{slice_metadata}},
\code{\link{subset}()}
}
\concept{transformations}
