% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.r
\name{bdiv_boxplot}
\alias{bdiv_boxplot}
\title{Visualize BIOM data with boxplots.}
\usage{
bdiv_boxplot(
  biom,
  x = NULL,
  bdiv = "Bray-Curtis",
  layers = "x",
  weighted = TRUE,
  tree = NULL,
  within = NULL,
  between = NULL,
  stat.by = x,
  facet.by = NULL,
  colors = TRUE,
  shapes = TRUE,
  patterns = FALSE,
  flip = FALSE,
  stripe = NULL,
  ci = "ci",
  level = 0.95,
  p.adj = "fdr",
  outliers = NULL,
  xlab.angle = "auto",
  p.label = 0.05,
  transform = "none",
  caption = TRUE,
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{x}{A categorical metadata column name to use for the x-axis. Or
\code{NULL}, which groups all samples into a single category.}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{layers}{One or more of
\code{c("bar", "box" ("x"), "violin", "dot", "strip", "crossbar", "errorbar", "linerange", "pointrange")}.
Single letter abbreviations are also accepted. For instance,
\code{c("box", "dot")} is equivalent to \code{c("x", "d")} and \code{"xd"}.
Default: \code{"x"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{within, between}{Dataset field(s) for intra- or inter- sample
comparisons. Alternatively, dataset field names given elsewhere can
be prefixed with \code{'=='} or \code{'!='} to assign them to \code{within} or
\code{between}, respectively. Default: \code{NULL}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{facet.by}{Dataset field(s) to use for faceting. Must be categorical.
Default: \code{NULL}}

\item{colors}{How to color the groups. Options are:
\describe{
\item{\code{TRUE} - }{ Automatically select colorblind-friendly colors. }
\item{\code{FALSE} or \code{NULL} - }{ Don't use colors. }
\item{a palette name - }{ Auto-select colors from this set. E.g. \code{"okabe"} }
\item{character vector - }{ Custom colors to use. E.g. \code{c("red", "#00FF00")} }
\item{named character vector - }{ Explicit mapping. E.g. \code{c(Male = "blue", Female = "red")} }
}
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{shapes}{Shapes for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, shape
names (typically integers 0 - 17), or a named vector mapping
groups to specific shape names.
See "Aesthetics" section below for additional information.
Default: \code{TRUE}}

\item{patterns}{Patterns for each group.
Options are similar to \code{colors}'s: \code{TRUE}, \code{FALSE}, \code{NULL}, pattern
names (\code{"brick"}, \code{"chevron"}, \code{"fish"}, \code{"grid"}, etc), or a named
vector mapping groups to specific pattern names.
See "Aesthetics" section below for additional information.
Default: \code{FALSE}}

\item{flip}{Transpose the axes, so that taxa are present as rows instead
of columns. Default: \code{FALSE}}

\item{stripe}{Shade every other x position. Default: \emph{same as flip}}

\item{ci}{How to calculate min/max of the \bold{crossbar},
\bold{errorbar}, \bold{linerange}, and \bold{pointrange} layers.
Options are: \code{"ci"} (confidence interval), \code{"range"},
\code{"sd"} (standard deviation), \code{"se"} (standard error), and
\code{"mad"} (median absolute deviation).
The center mark of \bold{crossbar} and \bold{pointrange} represents
the mean, except for \code{"mad"} in which case it represents the median.
Default: \code{"ci"}}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}

\item{outliers}{Show boxplot outliers? \code{TRUE} to always show.
\code{FALSE} to always hide. \code{NULL} to only hide them when
overlaying a dot or strip chart.  Default: \code{NULL}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{p.label}{Minimum adjusted p-value to display on the plot with a
bracket.
\describe{
\item{\code{p.label = 0.05} - }{ Show p-values that are <= 0.05. }
\item{\code{p.label = 0} - }{ Don't show any p-values on the plot. }
\item{\code{p.label = 1} - }{ Show all p-values on the plot. }
}
If a numeric vector with more than one value is
provided, they will be used as breaks for asterisk notation.
Default: \code{0.05}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}

\item{caption}{Add methodology caption beneath the plot.
Default: \code{TRUE}}

\item{...}{Additional parameters to pass along to ggplot2 functions.
Prefix a parameter name with a layer name to pass it to only that
layer. For instance, \code{d.size = 2} ensures only the points on the
\bold{dot} layer have their size set to \code{2}.}
}
\value{
A \code{ggplot2} plot. The computed data points, ggplot2 command,
stats table, and stats table commands are available as \verb{$data},
\verb{$code}, \verb{$stats}, and \verb{$stats$code}, respectively.
}
\description{
Visualize BIOM data with boxplots.
}
\section{Aesthetics}{


All built-in color palettes are colorblind-friendly. The available
categorical palette names are: \code{"okabe"}, \code{"carto"}, \code{"r4"},
\code{"polychrome"}, \code{"tol"}, \code{"bright"}, \code{"light"},
\code{"muted"}, \code{"vibrant"}, \code{"tableau"}, \code{"classic"},
\code{"alphabet"}, \code{"tableau20"}, \code{"kelly"}, and \code{"fishy"}.

Patterns are added using the fillpattern R package. Options are \code{"brick"},
\code{"chevron"}, \code{"fish"}, \code{"grid"}, \code{"herringbone"}, \code{"hexagon"}, \code{"octagon"},
\code{"rain"}, \code{"saw"}, \code{"shingle"}, \code{"rshingle"}, \code{"stripe"}, and \code{"wave"},
optionally abbreviated and/or suffixed with modifiers. For example,
\code{"hex10_sm"} for the hexagon pattern rotated 10 degrees and shrunk by 2x.
See \code{\link[fillpattern:fill_pattern]{fillpattern::fill_pattern()}} for complete documentation of options.

Shapes can be given as per base R - numbers 0 through 17 for various shapes,
or the decimal value of an ascii character, e.g. a-z = 65:90; A-Z = 97:122 to use
letters instead of shapes on the plot. Character strings may used as well.
}

\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    
    bdiv_boxplot(biom, x="==Body Site", bdiv="UniFrac", stat.by="Body Site")
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()}
}
\concept{beta_diversity}
\concept{visualization}
