% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_mutagenesis}
\alias{rba_uniprot_mutagenesis}
\title{Get Mutagenesis by UniProt Accession}
\usage{
rba_uniprot_mutagenesis(accession, location = NULL, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s).}

\item{location}{A valid amino acid range (e.g. 10-25) within the sequence
range of the given proein.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the mutagenesis description of your supplied
  UniProt protein's sequence.
}
\description{
UniProt describes the effects of mutations in proteins' amino acid
  sequence on the biological properties of the protein, cell or the
  organism. Using this function, you can get the
  \href{https://www.uniprot.org/help/mutagen}{
  Mutagenesis description} that has been mapped to a given UniProt protein.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/mutagenesis/{accession}"
}

\examples{
\donttest{
rba_uniprot_mutagenesis(accession = "P0DTC2", location = "300-400")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Mutagenesis": 
\code{\link{rba_uniprot_mutagenesis_search}()}
}
\concept{"UniProt - Mutagenesis"}
