% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_enrich}
\alias{rba_panther_enrich}
\title{PANTHER Over-Representation Enrichment Analysis}
\usage{
rba_panther_enrich(
  genes,
  organism,
  annot_dataset,
  test_type = "FISHER",
  correction = "FDR",
  cutoff = NULL,
  ref_genes = NULL,
  ref_organism = NULL,
  ...
)
}
\arguments{
\item{genes}{Character vector of genes identifiers with maximum length of
10000. Can be any of: Ensemble gene ID, Ensemble protein ID, Ensemble
transcript ID, Entrez gene ID, gene symbol, NCBI GI, HGNC ID,
International protein index ID, NCBI UniGene ID, UniProt accession
and/or UniProt ID.}

\item{organism}{(numeric) NCBI taxon ID. run \code{\link{rba_panther_info}}
with argument 'what = "organisms"' to get a list of PANTHER's
supported organisms.}

\item{annot_dataset}{A PANTHER dataset ID to test your input against it.
run \code{\link{rba_panther_info}}with argument 'what = "datasets"' to
get a list of PANTHER's supported datasets. Note that you should enter
the "id" of the dataset, not its label (e.g. entering "biological_process"
is incorrect, you should rather enter "GO:0008150").}

\item{test_type}{statistical test type to calculate the p values. either
"FISHER" (default) or "BINOMIAL".}

\item{correction}{p value correction method. either "FDR" (default),
"BONFERRONI" or "NONE".}

\item{cutoff}{(Numeric) (Optional) a threshold to filter the results.
if correction is "FDR", the threshold will be applied to fdr column's
values; if otherwise, the threshold will be applied to p value column.}

\item{ref_genes}{(Optional) A set of genes that will be used as the test's
background (reference/universe) gene set. If no value supplied, all of
the genes in specified organism will be used. maximum length and supported
IDs are the same as 'genes' argument.}

\item{ref_organism}{(Optional) if 'ref_genes' is used, you can specify
the organisms which correspond to your supplied IDs in 'ref_genes'
argument. see 'organism' argument for supported values.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list with the parameters and results. If the analysis was
  successful, the results data frame are returned in the "results" element
  within the list. Otherwise, an error message will be returned under the
  "search$error" element in the returned list.
}
\description{
Using this function you can use PANTHER services to perform
  over-representation enrichment analysis. This statistical test will
  compare your input genes to a set of defined gene lists to determine
  if they are over/under-represented.
}
\section{Corresponding API Resources}{

 "POST http://www.pantherdb.org/services/oai/pantherdb/enrich/overrep"
}

\examples{
\donttest{
rba_panther_enrich(genes = c("p53", "BRCA1", "cdk2", "Q99835", "CDC42",
        "CDK1", "KIF23", "PLK1", "RAC2", "RACGAP1"),
    organism = 9606, annot_dataset = "GO:0008150",
    cutoff = 0.01)
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{http://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
