% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_fit.R, R/predict_manual.R
\name{predict.fitTK}
\alias{predict.fitTK}
\alias{predict_manual}
\title{Prediction function using \code{fitTK} object}
\usage{
\method{predict}{fitTK}(object, data, mcmc_size = NULL, fixed_init = TRUE, ...)

predict_manual(
  param,
  data,
  time_accumulation = NULL,
  C0 = 0,
  G0 = NA,
  gmax = NA
)
}
\arguments{
\item{object}{An object of \code{stanfit}}

\item{data}{A data set with one column \code{time} and 1 to 4 exposure}

\item{mcmc_size}{Size of mcmc chain if needed to be reduced}

\item{fixed_init}{If \code{TRUE} fix the initial conditions of internal concentration.
columns with name in \code{expw}, \code{exps}, \code{expf} and \code{exppw}}

\item{\dots}{Additional arguments}

\item{param}{A dataframe with name of parameters \code{kee}, \code{keg}, \code{ku1},
\code{ku2}, ...,  \code{km1}, \code{km2}, ... and \code{kem1}, \code{kem2}, ...,
\code{sigmaConc}, \code{sigmaCmet} (if metabolites) and \code{sigmaGrowth} (if growth).}

\item{time_accumulation}{the time of accumulation.}

\item{C0}{Gives the initial conditions of internal concentration.}

\item{G0}{initial condition of G0 (require if \code{keg} is provided)}

\item{gmax}{gmax (require if \code{keg} is provided)
columns with name in \code{expw}, \code{exps}, \code{expf} and \code{exppw}}
}
\value{
An object of class \code{predictTK}

An object of class \code{predictTK}
}
\description{
Use when parameter are manually given by the user.
}
