% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{libbi_clone}
\alias{libbi_clone}
\title{Clone a libbi object}
\arguments{
\item{model}{a libbi model (or path to a model file), if the cloned libbi object is to use a different model}

\item{...}{any options to the new \code{libbi} object}
}
\description{
Returns a copy of the libbi object with exactly the same properties as the original object (except for any parameters given to the \code{clone} call)
}
\examples{
bi_object <- libbi$new(client = "sample",
                       model = system.file(package="rbi", "PZ.bi"),
                       options = list(sampler = "smc2"))
bi_object_new <- bi_object$clone()
}
\seealso{
\code{\link{libbi}}
}

