% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_particles.R
\name{adapt_particles}
\alias{adapt_particles}
\title{Adapt the number of particles}
\usage{
adapt_particles(x, min = 1, max = 1024, target.variance = 1,
  quiet = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link{libbi}} object}

\item{min}{minimum number of particles}

\item{max}{maximum number of particles}

\item{target.variance}{target log-likelihood variance; once this is crossed, the current number of particles will be used}

\item{quiet}{if set to TRUE, will not provide running output of particle numbers tested}

\item{...}{parameters for libbi$run}
}
\value{
a \code{\link{libbi}} with the desired proposal distribution
}
\description{
This function takes the provided \code{\link{libbi}} and
  runs MCMC at a single point (i.e., repeatedly proposing the same parameters),
  adapting the number of particles distribution until the variance of the log-likelihood
  crosses the value given as \code{target.variance} (1 by default).
}
\examples{
example_obs <- bi_read(system.file(package="rbi", "example_dataset.nc"))
example_model <- bi_model(system.file(package="rbi", "PZ.bi"))
example_bi <- libbi(model = example_model, obs = example_obs)
obs_states <- var_names(example_model, "obs")
max_time <- max(vapply(example_obs[obs_states], function(x) { max(x[["time"]])}, 0))
\donttest{adapted <- adapt_particles(example_bi, nsamples = 128, end_time = max_time)}
}
